/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MapClearTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testClear() {
        this.getMap().clear();
        MapClearTester.assertTrue((String)"After clear(), a map should be empty.", (boolean)this.getMap().isEmpty());
        MapClearTester.assertEquals((int)0, (int)this.getMap().size());
        MapClearTester.assertFalse((boolean)this.getMap().entrySet().iterator().hasNext());
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testClearConcurrentWithEntrySetIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.getMap().entrySet().iterator();
            this.getMap().clear();
            iterator.next();
        });
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testClearConcurrentWithKeySetIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.getMap().keySet().iterator();
            this.getMap().clear();
            iterator.next();
        });
    }

    @MapFeature.Require(value={MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testClearConcurrentWithValuesIteration() {
        ReflectionFreeAssertThrows.assertThrows(ConcurrentModificationException.class, () -> {
            Iterator iterator = this.getMap().values().iterator();
            this.getMap().clear();
            iterator.next();
        });
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClear_unsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getMap().clear());
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testClear_unsupportedByEmptyCollection() {
        try {
            this.getMap().clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

