/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.ReflectionFreeAssertThrows;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.NullMarked;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@NullMarked
@GwtCompatible
public class ConcurrentMapReplaceTester<K, V>
extends AbstractMapTester<K, V> {
    @Override
    protected ConcurrentMap<K, V> getMap() {
        return (ConcurrentMap)super.getMap();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplace_supportedPresent() {
        ConcurrentMapReplaceTester.assertEquals(this.v0(), this.getMap().replace(this.k0(), this.v3()));
        this.expectReplacement(this.entry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplace_supportedPresentNoChange() {
        ConcurrentMapReplaceTester.assertEquals(this.v0(), this.getMap().replace(this.k0(), this.v0()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testReplace_supportedAbsent() {
        ConcurrentMapReplaceTester.assertNull(this.getMap().replace(this.k3(), this.v3()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplace_presentNullValueUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.getMap().replace(this.k0(), null));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testReplace_absentNullValueUnsupported() {
        try {
            this.getMap().replace(this.k3(), null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testReplace_absentNullKeyUnsupported() {
        try {
            this.getMap().replace(null, this.v3());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testReplace_unsupportedPresent() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.getMap().replace(this.k0(), this.v3()));
        this.expectUnchanged();
    }
}

