/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.collect.testing.google.GoogleHelpers;
import java.util.Collection;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MultimapRemoveAllTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllAbsentKey() {
        Helpers.assertEmpty(this.multimap().removeAll(this.k3()));
        this.expectUnchanged();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllPresentKey() {
        Helpers.assertContentsAnyOrder(this.multimap().removeAll(this.k0()), this.v0());
        this.expectMissing((Map.Entry)this.e0());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllPropagatesToGet() {
        Collection getResult = this.multimap().get(this.k0());
        this.multimap().removeAll(this.k0());
        Helpers.assertEmpty(getResult);
        this.expectMissing((Map.Entry)this.e0());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemoveAllMultipleValues() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k0(), this.v2()));
        Helpers.assertContentsAnyOrder(this.multimap().removeAll(this.k0()), this.v0(), this.v1(), this.v2());
        GoogleHelpers.assertEmpty(this.multimap());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_KEYS})
    public void testRemoveAllNullKeyPresent() {
        this.initMultimapWithNullKey();
        Helpers.assertContentsAnyOrder(this.multimap().removeAll(null), this.getValueForNullKey());
        this.expectMissing(Helpers.mapEntry(null, this.getValueForNullKey()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_ANY_NULL_QUERIES})
    public void testRemoveAllNullKeyAbsent() {
        Helpers.assertEmpty(this.multimap().removeAll(null));
        this.expectUnchanged();
    }
}

