/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractBiMapTester;
import com.google.common.collect.testing.google.ReflectionFreeAssertThrows;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class BiMapPutTester<K, V>
extends AbstractBiMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testPutWithSameValueFails() {
        this.getMap().put(this.k0(), this.v0());
        ReflectionFreeAssertThrows.assertThrows(IllegalArgumentException.class, () -> this.getMap().put(this.k1(), this.v0()));
        this.expectAdded((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testPutPresentKeyDifferentValue() {
        this.getMap().put(this.k0(), this.v0());
        this.getMap().put(this.k0(), this.v1());
        this.expectContents(Helpers.mapEntry(this.k0(), this.v1()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void putDistinctKeysDistinctValues() {
        this.getMap().put(this.k0(), this.v0());
        this.getMap().put(this.k1(), this.v1());
        this.expectAdded((Map.Entry)this.e0(), (Map.Entry)this.e1());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testForcePutKeyPresent() {
        this.getMap().forcePut(this.k0(), this.v1());
        this.expectContents(Helpers.mapEntry(this.k0(), this.v1()));
        BiMapPutTester.assertFalse((boolean)this.getMap().containsValue(this.v0()));
        BiMapPutTester.assertNull((Object)this.getMap().inverse().get(this.v0()));
        BiMapPutTester.assertEquals((int)1, (int)this.getMap().size());
        BiMapPutTester.assertTrue((boolean)this.getMap().containsKey(this.k0()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testForcePutValuePresent() {
        this.getMap().forcePut(this.k1(), this.v0());
        this.expectContents(Helpers.mapEntry(this.k1(), this.v0()));
        BiMapPutTester.assertEquals(this.k1(), (Object)this.getMap().inverse().get(this.v0()));
        BiMapPutTester.assertEquals((int)1, (int)this.getMap().size());
        BiMapPutTester.assertFalse((boolean)this.getMap().containsKey(this.k0()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testForcePutKeyAndValuePresent() {
        this.getMap().forcePut(this.k0(), this.v1());
        this.expectContents(Helpers.mapEntry(this.k0(), this.v1()), Helpers.mapEntry(this.k2(), this.v2()));
        BiMapPutTester.assertEquals((int)2, (int)this.getMap().size());
        BiMapPutTester.assertFalse((boolean)this.getMap().containsKey(this.k1()));
        BiMapPutTester.assertFalse((boolean)this.getMap().containsValue(this.v0()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testForcePutNullKeyPresent() {
        this.initMapWithNullKey();
        this.getMap().forcePut(null, this.v1());
        this.expectContents(Helpers.mapEntry(null, this.v1()));
        BiMapPutTester.assertFalse((boolean)this.getMap().containsValue(this.v0()));
        BiMapPutTester.assertTrue((boolean)this.getMap().containsValue(this.v1()));
        BiMapPutTester.assertTrue((boolean)this.getMap().inverse().containsKey(this.v1()));
        BiMapPutTester.assertNull((Object)this.getMap().inverse().get(this.v1()));
        BiMapPutTester.assertEquals(this.v1(), (Object)this.getMap().get(null));
        BiMapPutTester.assertEquals((int)1, (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testForcePutNullValuePresent() {
        this.initMapWithNullValue();
        this.getMap().forcePut(this.k1(), null);
        this.expectContents(Helpers.mapEntry(this.k1(), null));
        BiMapPutTester.assertFalse((boolean)this.getMap().containsKey(this.k0()));
        BiMapPutTester.assertTrue((boolean)this.getMap().containsKey(this.k1()));
        BiMapPutTester.assertTrue((boolean)this.getMap().inverse().containsKey(null));
        BiMapPutTester.assertNull((Object)this.getMap().get(this.k1()));
        BiMapPutTester.assertEquals(this.k1(), (Object)this.getMap().inverse().get(null));
        BiMapPutTester.assertEquals((int)1, (int)this.getMap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testInversePut() {
        this.getMap().put(this.k0(), this.v0());
        this.getMap().inverse().put(this.v1(), this.k1());
        this.expectAdded((Map.Entry)this.e0(), (Map.Entry)this.e1());
    }
}

