/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.ElementTypesAreNonnullByDefault;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.Platform;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import junit.framework.Assert;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class SpliteratorTester<E> {
    private final ImmutableSet<Supplier<GeneralSpliterator<E>>> spliteratorSuppliers;

    private static <E> @Nullable GeneralSpliterator<E> trySplitTestingSize(GeneralSpliterator<E> spliterator) {
        boolean subsized = spliterator.hasCharacteristics(16384);
        long originalSize = spliterator.estimateSize();
        GeneralSpliterator<E> trySplit = spliterator.trySplit();
        if (spliterator.estimateSize() > originalSize) {
            Assert.fail((String)Platform.format("estimated size of spliterator after trySplit (%s) is larger than original size (%s)", spliterator.estimateSize(), originalSize));
        }
        if (trySplit != null && trySplit.estimateSize() > originalSize) {
            Assert.fail((String)Platform.format("estimated size of trySplit result (%s) is larger than original size (%s)", trySplit.estimateSize(), originalSize));
        }
        if (subsized) {
            if (trySplit != null) {
                Assert.assertEquals((String)"sum of estimated sizes of trySplit and original spliterator after trySplit", (long)originalSize, (long)(trySplit.estimateSize() + spliterator.estimateSize()));
            } else {
                Assert.assertEquals((String)"estimated size of spliterator after failed trySplit", (long)originalSize, (long)spliterator.estimateSize());
            }
        }
        return trySplit;
    }

    public static <E> SpliteratorTester<E> of(Supplier<Spliterator<E>> spliteratorSupplier) {
        return new SpliteratorTester<E>(ImmutableSet.of(() -> new GeneralSpliteratorOfObject((Spliterator)spliteratorSupplier.get())));
    }

    public static SpliteratorTester<Integer> ofInt(Supplier<Spliterator.OfInt> spliteratorSupplier) {
        return new SpliteratorTester<Integer>(ImmutableSet.of(() -> new GeneralSpliteratorOfObject((Spliterator)spliteratorSupplier.get()), () -> new GeneralSpliteratorOfPrimitive((Spliterator.OfPrimitive)spliteratorSupplier.get(), c -> c::accept)));
    }

    public static SpliteratorTester<Long> ofLong(Supplier<Spliterator.OfLong> spliteratorSupplier) {
        return new SpliteratorTester<Long>(ImmutableSet.of(() -> new GeneralSpliteratorOfObject((Spliterator)spliteratorSupplier.get()), () -> new GeneralSpliteratorOfPrimitive((Spliterator.OfPrimitive)spliteratorSupplier.get(), c -> c::accept)));
    }

    public static SpliteratorTester<Double> ofDouble(Supplier<Spliterator.OfDouble> spliteratorSupplier) {
        return new SpliteratorTester<Double>(ImmutableSet.of(() -> new GeneralSpliteratorOfObject((Spliterator)spliteratorSupplier.get()), () -> new GeneralSpliteratorOfPrimitive((Spliterator.OfPrimitive)spliteratorSupplier.get(), c -> c::accept)));
    }

    private SpliteratorTester(ImmutableSet<Supplier<GeneralSpliterator<E>>> spliteratorSuppliers) {
        this.spliteratorSuppliers = (ImmutableSet)Preconditions.checkNotNull(spliteratorSuppliers);
    }

    @SafeVarargs
    @CanIgnoreReturnValue
    public final Ordered expect(Object ... elements) {
        return this.expect(Arrays.asList(elements));
    }

    @CanIgnoreReturnValue
    public final Ordered expect(final Iterable<?> elements) {
        final ArrayList resultsForAllStrategies = new ArrayList();
        for (Supplier spliteratorSupplier : this.spliteratorSuppliers) {
            GeneralSpliterator spliterator = (GeneralSpliterator)spliteratorSupplier.get();
            int characteristics = spliterator.characteristics();
            long estimatedSize = spliterator.estimateSize();
            for (SpliteratorDecompositionStrategy strategy : SpliteratorDecompositionStrategy.ALL_STRATEGIES) {
                ArrayList resultsForStrategy = new ArrayList();
                strategy.forEach((GeneralSpliterator)spliteratorSupplier.get(), resultsForStrategy::add);
                if ((characteristics & 0x100) != 0) {
                    Assert.assertFalse((boolean)resultsForStrategy.contains(null));
                }
                if ((characteristics & 4) != 0) {
                    Comparator<Object> comparator = spliterator.getComparator();
                    if (comparator == null) {
                        Comparator naturalOrder = Comparator.naturalOrder();
                        comparator = naturalOrder;
                    }
                    Assert.assertTrue((boolean)Ordering.from(comparator).isOrdered(resultsForStrategy));
                }
                if ((characteristics & 0x40) != 0) {
                    Assert.assertEquals((int)Ints.checkedCast((long)estimatedSize), (int)resultsForStrategy.size());
                }
                Helpers.assertEqualIgnoringOrder(elements, resultsForStrategy);
                resultsForAllStrategies.add(resultsForStrategy);
            }
        }
        return new Ordered(){

            @Override
            public void inOrder() {
                for (List resultsForStrategy : resultsForAllStrategies) {
                    Helpers.assertEqualInOrder(elements, resultsForStrategy);
                }
            }
        };
    }

    static enum SpliteratorDecompositionStrategy {
        NO_SPLIT_FOR_EACH_REMAINING{

            @Override
            <E> void forEach(GeneralSpliterator<E> spliterator, Consumer<? super E> consumer) {
                spliterator.forEachRemaining(consumer);
            }
        }
        ,
        NO_SPLIT_TRY_ADVANCE{

            @Override
            <E> void forEach(GeneralSpliterator<E> spliterator, Consumer<? super E> consumer) {
                while (spliterator.tryAdvance(consumer)) {
                }
            }
        }
        ,
        MAXIMUM_SPLIT{

            @Override
            <E> void forEach(GeneralSpliterator<E> spliterator, Consumer<? super E> consumer) {
                GeneralSpliterator prefix = SpliteratorTester.trySplitTestingSize(spliterator);
                while (prefix != null) {
                    this.forEach(prefix, consumer);
                    prefix = SpliteratorTester.trySplitTestingSize(spliterator);
                }
                long size = spliterator.getExactSizeIfKnown();
                long[] counter = new long[]{0L};
                spliterator.forEachRemaining(e -> {
                    consumer.accept((Object)e);
                    counter[0] = counter[0] + 1L;
                });
                if (size >= 0L) {
                    Assert.assertEquals((long)size, (long)counter[0]);
                }
            }
        }
        ,
        ALTERNATE_ADVANCE_AND_SPLIT{

            @Override
            <E> void forEach(GeneralSpliterator<E> spliterator, Consumer<? super E> consumer) {
                while (spliterator.tryAdvance(consumer)) {
                    GeneralSpliterator prefix = SpliteratorTester.trySplitTestingSize(spliterator);
                    if (prefix == null) continue;
                    this.forEach(prefix, consumer);
                }
            }
        };

        static final Set<SpliteratorDecompositionStrategy> ALL_STRATEGIES;

        abstract <E> void forEach(GeneralSpliterator<E> var1, Consumer<? super E> var2);

        static {
            ALL_STRATEGIES = Collections.unmodifiableSet(new LinkedHashSet<SpliteratorDecompositionStrategy>(Arrays.asList(SpliteratorDecompositionStrategy.values())));
        }
    }

    private static final class GeneralSpliteratorOfPrimitive<E, C, S extends Spliterator.OfPrimitive<E, C, S>>
    extends GeneralSpliterator<E> {
        final Spliterator.OfPrimitive<E, C, S> spliteratorOfPrimitive;
        final Function<Consumer<? super E>, C> consumerizer;

        GeneralSpliteratorOfPrimitive(Spliterator.OfPrimitive<E, C, S> spliterator, Function<Consumer<? super E>, C> consumerizer) {
            super(spliterator);
            this.spliteratorOfPrimitive = spliterator;
            this.consumerizer = consumerizer;
        }

        @Override
        void forEachRemaining(Consumer<? super E> action) {
            this.spliteratorOfPrimitive.forEachRemaining(this.consumerizer.apply(action));
        }

        @Override
        boolean tryAdvance(Consumer<? super E> action) {
            return this.spliteratorOfPrimitive.tryAdvance(this.consumerizer.apply(action));
        }

        @Override
        @Nullable GeneralSpliterator<E> trySplit() {
            Spliterator split = this.spliteratorOfPrimitive.trySplit();
            return split == null ? null : new GeneralSpliteratorOfPrimitive<E, C, S>(split, this.consumerizer);
        }
    }

    private static final class GeneralSpliteratorOfObject<E>
    extends GeneralSpliterator<E> {
        GeneralSpliteratorOfObject(Spliterator<E> spliterator) {
            super(spliterator);
        }

        @Override
        void forEachRemaining(Consumer<? super E> action) {
            this.spliterator.forEachRemaining(action);
        }

        @Override
        boolean tryAdvance(Consumer<? super E> action) {
            return this.spliterator.tryAdvance(action);
        }

        @Override
        @Nullable GeneralSpliterator<E> trySplit() {
            Spliterator split = this.spliterator.trySplit();
            return split == null ? null : new GeneralSpliteratorOfObject(split);
        }
    }

    private static abstract class GeneralSpliterator<E> {
        final Spliterator<E> spliterator;

        GeneralSpliterator(Spliterator<E> spliterator) {
            this.spliterator = (Spliterator)Preconditions.checkNotNull(spliterator);
        }

        abstract void forEachRemaining(Consumer<? super E> var1);

        abstract boolean tryAdvance(Consumer<? super E> var1);

        abstract @Nullable GeneralSpliterator<E> trySplit();

        final int characteristics() {
            return this.spliterator.characteristics();
        }

        final long estimateSize() {
            return this.spliterator.estimateSize();
        }

        final Comparator<? super E> getComparator() {
            return this.spliterator.getComparator();
        }

        final long getExactSizeIfKnown() {
            return this.spliterator.getExactSizeIfKnown();
        }

        final boolean hasCharacteristics(int characteristics) {
            return this.spliterator.hasCharacteristics(characteristics);
        }
    }

    public static interface Ordered {
        public void inOrder();
    }
}

