/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SpliteratorTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.lang.reflect.Method;
import java.util.Collection;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class CollectionSpliteratorTester<E>
extends AbstractCollectionTester<E> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CollectionFeature.Require(absent={CollectionFeature.KNOWN_ORDER})
    public void testSpliteratorUnknownOrder() {
        Collection collection = this.collection;
        synchronized (collection) {
            SpliteratorTester.of(this.collection::spliterator).expect(this.getSampleElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CollectionFeature.Require(value={CollectionFeature.KNOWN_ORDER})
    public void testSpliteratorKnownOrder() {
        Collection collection = this.collection;
        synchronized (collection) {
            SpliteratorTester.of(this.collection::spliterator).expect(this.getOrderedElements()).inOrder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CollectionFeature.Require(value={CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testSpliteratorNullable() {
        this.initCollectionWithNullElement();
        Collection collection = this.collection;
        synchronized (collection) {
            CollectionSpliteratorTester.assertFalse((boolean)this.collection.spliterator().hasCharacteristics(256));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testSpliteratorNotImmutable_CollectionAllowsAdd() {
        Collection collection = this.collection;
        synchronized (collection) {
            CollectionSpliteratorTester.assertFalse((boolean)this.collection.spliterator().hasCharacteristics(1024));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testSpliteratorNotImmutable_CollectionAllowsRemove() {
        Collection collection = this.collection;
        synchronized (collection) {
            CollectionSpliteratorTester.assertFalse((boolean)this.collection.spliterator().hasCharacteristics(1024));
        }
    }

    @GwtIncompatible
    public static Method getSpliteratorNotImmutableCollectionAllowsAddMethod() {
        return Helpers.getMethod(CollectionSpliteratorTester.class, "testSpliteratorNotImmutable_CollectionAllowsAdd");
    }

    @GwtIncompatible
    public static Method getSpliteratorNotImmutableCollectionAllowsRemoveMethod() {
        return Helpers.getMethod(CollectionSpliteratorTester.class, "testSpliteratorNotImmutable_CollectionAllowsRemove");
    }
}

