/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.testers.AbstractSetTester;
import java.lang.reflect.Method;
import java.util.Collection;
import org.junit.Ignore;

@Ignore
@GwtCompatible(emulated=true)
public class SetAddTester<E>
extends AbstractSetTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAdd_supportedPresent() {
        SetAddTester.assertFalse((String)"add(present) should return false", (boolean)this.getSet().add(this.e0()));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD, CollectionFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testAdd_supportedNullPresent() {
        Object[] array = this.createArrayWithNullElement();
        this.collection = (Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(array);
        SetAddTester.assertFalse((String)"add(nullPresent) should return false", (boolean)this.getSet().add(null));
        this.expectContents(array);
    }

    @GwtIncompatible
    public static Method getAddSupportedNullPresentMethod() {
        return Helpers.getMethod(SetAddTester.class, "testAdd_supportedNullPresent");
    }
}

