/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent.testing;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.testing.AbstractListenableFutureTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@Beta
@GwtIncompatible
public abstract class AbstractCheckedFutureTest
extends AbstractListenableFutureTest {
    protected abstract <V> CheckedFuture<V, ?> createCheckedFuture(V var1, Exception var2, CountDownLatch var3);

    protected abstract void checkCancelledException(Exception var1);

    protected abstract void checkExecutionException(Exception var1);

    protected abstract void checkInterruptedException(Exception var1);

    @Override
    protected <V> ListenableFuture<V> createListenableFuture(V value, Exception except, CountDownLatch waitOn) {
        return this.createCheckedFuture(value, except, waitOn);
    }

    public void testCheckedGetThrowsApplicationExceptionOnCancellation() {
        final CheckedFuture<Boolean, ?> future = this.createCheckedFuture(Boolean.TRUE, null, this.latch);
        AbstractCheckedFutureTest.assertFalse((boolean)future.isDone());
        AbstractCheckedFutureTest.assertFalse((boolean)future.isCancelled());
        new Thread(new Runnable(){

            @Override
            public void run() {
                future.cancel(true);
            }
        }).start();
        try {
            future.checkedGet();
            AbstractCheckedFutureTest.fail((String)"RPC Should have been cancelled.");
        }
        catch (Exception e) {
            this.checkCancelledException(e);
        }
        AbstractCheckedFutureTest.assertTrue((boolean)future.isDone());
        AbstractCheckedFutureTest.assertTrue((boolean)future.isCancelled());
    }

    public void testCheckedGetThrowsApplicationExceptionOnInterruption() throws InterruptedException {
        final CheckedFuture<Boolean, ?> future = this.createCheckedFuture(Boolean.TRUE, null, this.latch);
        final CountDownLatch startingGate = new CountDownLatch(1);
        final CountDownLatch successLatch = new CountDownLatch(1);
        AbstractCheckedFutureTest.assertFalse((boolean)future.isDone());
        AbstractCheckedFutureTest.assertFalse((boolean)future.isCancelled());
        Thread getThread = new Thread(new Runnable(){

            @Override
            public void run() {
                startingGate.countDown();
                try {
                    future.checkedGet();
                }
                catch (Exception e) {
                    AbstractCheckedFutureTest.this.checkInterruptedException(e);
                    successLatch.countDown();
                }
            }
        });
        getThread.start();
        AbstractCheckedFutureTest.assertTrue((boolean)startingGate.await(500L, TimeUnit.MILLISECONDS));
        getThread.interrupt();
        AbstractCheckedFutureTest.assertTrue((boolean)successLatch.await(500L, TimeUnit.MILLISECONDS));
        AbstractCheckedFutureTest.assertFalse((boolean)future.isDone());
        AbstractCheckedFutureTest.assertFalse((boolean)future.isCancelled());
    }

    public void testCheckedGetThrowsApplicationExceptionOnError() {
        CheckedFuture<Boolean, ?> future = this.createCheckedFuture(Boolean.TRUE, new Exception("Error"), this.latch);
        AbstractCheckedFutureTest.assertFalse((boolean)future.isDone());
        AbstractCheckedFutureTest.assertFalse((boolean)future.isCancelled());
        new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractCheckedFutureTest.this.latch.countDown();
            }
        }).start();
        try {
            future.checkedGet();
            AbstractCheckedFutureTest.fail();
        }
        catch (Exception e) {
            this.checkExecutionException(e);
        }
        AbstractCheckedFutureTest.assertTrue((boolean)future.isDone());
        AbstractCheckedFutureTest.assertFalse((boolean)future.isCancelled());
    }
}

