/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_VideoGenerationReferenceImage;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import com.google.genai.types.VideoGenerationReferenceType;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class VideoGenerationReferenceImage
extends JsonSerializable {
    @JsonProperty(value="image")
    public abstract Optional<Image> image();

    @JsonProperty(value="referenceType")
    public abstract Optional<VideoGenerationReferenceType> referenceType();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_VideoGenerationReferenceImage.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static VideoGenerationReferenceImage fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, VideoGenerationReferenceImage.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_VideoGenerationReferenceImage.Builder();
        }

        @JsonProperty(value="image")
        public abstract Builder image(Image var1);

        @CanIgnoreReturnValue
        public Builder image(Image.Builder imageBuilder) {
            return this.image(imageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder image(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearImage() {
            return this.image(Optional.empty());
        }

        @JsonProperty(value="referenceType")
        public abstract Builder referenceType(VideoGenerationReferenceType var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceType(Optional<VideoGenerationReferenceType> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceType() {
            return this.referenceType(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder referenceType(VideoGenerationReferenceType.Known knownType) {
            return this.referenceType(new VideoGenerationReferenceType(knownType));
        }

        @CanIgnoreReturnValue
        public Builder referenceType(String referenceType) {
            return this.referenceType(new VideoGenerationReferenceType(referenceType));
        }

        public abstract VideoGenerationReferenceImage build();
    }
}

