/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_UpscaleImageParameters;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Image;
import com.google.genai.types.UpscaleImageConfig;
import java.util.Optional;

@InternalApi
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class UpscaleImageParameters
extends JsonSerializable {
    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="image")
    public abstract Optional<Image> image();

    @JsonProperty(value="upscaleFactor")
    public abstract Optional<String> upscaleFactor();

    @JsonProperty(value="config")
    public abstract Optional<UpscaleImageConfig> config();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_UpscaleImageParameters.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static UpscaleImageParameters fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, UpscaleImageParameters.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_UpscaleImageParameters.Builder();
        }

        @JsonProperty(value="model")
        public abstract Builder model(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder model(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModel() {
            return this.model(Optional.empty());
        }

        @JsonProperty(value="image")
        public abstract Builder image(Image var1);

        @CanIgnoreReturnValue
        public Builder image(Image.Builder imageBuilder) {
            return this.image(imageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder image(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearImage() {
            return this.image(Optional.empty());
        }

        @JsonProperty(value="upscaleFactor")
        public abstract Builder upscaleFactor(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder upscaleFactor(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUpscaleFactor() {
            return this.upscaleFactor(Optional.empty());
        }

        @JsonProperty(value="config")
        public abstract Builder config(UpscaleImageConfig var1);

        @CanIgnoreReturnValue
        public Builder config(UpscaleImageConfig.Builder configBuilder) {
            return this.config(configBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder config(Optional<UpscaleImageConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearConfig() {
            return this.config(Optional.empty());
        }

        public abstract UpscaleImageParameters build();
    }
}

