/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_TunedModel;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.TunedModelCheckpoint;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class TunedModel
extends JsonSerializable {
    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="endpoint")
    public abstract Optional<String> endpoint();

    @JsonProperty(value="checkpoints")
    public abstract Optional<List<TunedModelCheckpoint>> checkpoints();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_TunedModel.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static TunedModel fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, TunedModel.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_TunedModel.Builder();
        }

        @JsonProperty(value="model")
        public abstract Builder model(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder model(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModel() {
            return this.model(Optional.empty());
        }

        @JsonProperty(value="endpoint")
        public abstract Builder endpoint(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder endpoint(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEndpoint() {
            return this.endpoint(Optional.empty());
        }

        @JsonProperty(value="checkpoints")
        public abstract Builder checkpoints(List<TunedModelCheckpoint> var1);

        @CanIgnoreReturnValue
        public Builder checkpoints(TunedModelCheckpoint ... checkpoints) {
            return this.checkpoints(Arrays.asList(checkpoints));
        }

        @CanIgnoreReturnValue
        public Builder checkpoints(TunedModelCheckpoint.Builder ... checkpointsBuilders) {
            return this.checkpoints((List)Arrays.asList(checkpointsBuilders).stream().map(TunedModelCheckpoint.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder checkpoints(Optional<List<TunedModelCheckpoint>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCheckpoints() {
            return this.checkpoints(Optional.empty());
        }

        public abstract TunedModel build();
    }
}

