/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Model;
import com.google.genai.types.Checkpoint;
import com.google.genai.types.Endpoint;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.TunedModelInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Model
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="displayName")
    public abstract Optional<String> displayName();

    @JsonProperty(value="description")
    public abstract Optional<String> description();

    @JsonProperty(value="version")
    public abstract Optional<String> version();

    @JsonProperty(value="endpoints")
    public abstract Optional<List<Endpoint>> endpoints();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @JsonProperty(value="tunedModelInfo")
    public abstract Optional<TunedModelInfo> tunedModelInfo();

    @JsonProperty(value="inputTokenLimit")
    public abstract Optional<Integer> inputTokenLimit();

    @JsonProperty(value="outputTokenLimit")
    public abstract Optional<Integer> outputTokenLimit();

    @JsonProperty(value="supportedActions")
    public abstract Optional<List<String>> supportedActions();

    @JsonProperty(value="defaultCheckpointId")
    public abstract Optional<String> defaultCheckpointId();

    @JsonProperty(value="checkpoints")
    public abstract Optional<List<Checkpoint>> checkpoints();

    @JsonProperty(value="temperature")
    public abstract Optional<Float> temperature();

    @JsonProperty(value="maxTemperature")
    public abstract Optional<Float> maxTemperature();

    @JsonProperty(value="topP")
    public abstract Optional<Float> topP();

    @JsonProperty(value="topK")
    public abstract Optional<Integer> topK();

    @JsonProperty(value="thinking")
    public abstract Optional<Boolean> thinking();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Model.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Model fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Model.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Model.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="displayName")
        public abstract Builder displayName(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder displayName(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDisplayName() {
            return this.displayName(Optional.empty());
        }

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder description(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDescription() {
            return this.description(Optional.empty());
        }

        @JsonProperty(value="version")
        public abstract Builder version(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder version(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVersion() {
            return this.version(Optional.empty());
        }

        @JsonProperty(value="endpoints")
        public abstract Builder endpoints(List<Endpoint> var1);

        @CanIgnoreReturnValue
        public Builder endpoints(Endpoint ... endpoints) {
            return this.endpoints(Arrays.asList(endpoints));
        }

        @CanIgnoreReturnValue
        public Builder endpoints(Endpoint.Builder ... endpointsBuilders) {
            return this.endpoints((List)Arrays.asList(endpointsBuilders).stream().map(Endpoint.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder endpoints(Optional<List<Endpoint>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEndpoints() {
            return this.endpoints(Optional.empty());
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder labels(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLabels() {
            return this.labels(Optional.empty());
        }

        @JsonProperty(value="tunedModelInfo")
        public abstract Builder tunedModelInfo(TunedModelInfo var1);

        @CanIgnoreReturnValue
        public Builder tunedModelInfo(TunedModelInfo.Builder tunedModelInfoBuilder) {
            return this.tunedModelInfo(tunedModelInfoBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tunedModelInfo(Optional<TunedModelInfo> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTunedModelInfo() {
            return this.tunedModelInfo(Optional.empty());
        }

        @JsonProperty(value="inputTokenLimit")
        public abstract Builder inputTokenLimit(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder inputTokenLimit(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearInputTokenLimit() {
            return this.inputTokenLimit(Optional.empty());
        }

        @JsonProperty(value="outputTokenLimit")
        public abstract Builder outputTokenLimit(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputTokenLimit(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputTokenLimit() {
            return this.outputTokenLimit(Optional.empty());
        }

        @JsonProperty(value="supportedActions")
        public abstract Builder supportedActions(List<String> var1);

        @CanIgnoreReturnValue
        public Builder supportedActions(String ... supportedActions) {
            return this.supportedActions(Arrays.asList(supportedActions));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder supportedActions(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSupportedActions() {
            return this.supportedActions(Optional.empty());
        }

        @JsonProperty(value="defaultCheckpointId")
        public abstract Builder defaultCheckpointId(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder defaultCheckpointId(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDefaultCheckpointId() {
            return this.defaultCheckpointId(Optional.empty());
        }

        @JsonProperty(value="checkpoints")
        public abstract Builder checkpoints(List<Checkpoint> var1);

        @CanIgnoreReturnValue
        public Builder checkpoints(Checkpoint ... checkpoints) {
            return this.checkpoints(Arrays.asList(checkpoints));
        }

        @CanIgnoreReturnValue
        public Builder checkpoints(Checkpoint.Builder ... checkpointsBuilders) {
            return this.checkpoints((List)Arrays.asList(checkpointsBuilders).stream().map(Checkpoint.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder checkpoints(Optional<List<Checkpoint>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCheckpoints() {
            return this.checkpoints(Optional.empty());
        }

        @JsonProperty(value="temperature")
        public abstract Builder temperature(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder temperature(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTemperature() {
            return this.temperature(Optional.empty());
        }

        @JsonProperty(value="maxTemperature")
        public abstract Builder maxTemperature(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxTemperature(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxTemperature() {
            return this.maxTemperature(Optional.empty());
        }

        @JsonProperty(value="topP")
        public abstract Builder topP(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topP(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopP() {
            return this.topP(Optional.empty());
        }

        @JsonProperty(value="topK")
        public abstract Builder topK(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder topK(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTopK() {
            return this.topK(Optional.empty());
        }

        @JsonProperty(value="thinking")
        public abstract Builder thinking(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder thinking(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearThinking() {
            return this.thinking(Optional.empty());
        }

        public abstract Model build();
    }
}

