/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_FunctionCall;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.PartialArg;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class FunctionCall
extends JsonSerializable {
    @JsonProperty(value="id")
    public abstract Optional<String> id();

    @JsonProperty(value="args")
    public abstract Optional<Map<String, Object>> args();

    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="partialArgs")
    public abstract Optional<List<PartialArg>> partialArgs();

    @JsonProperty(value="willContinue")
    public abstract Optional<Boolean> willContinue();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_FunctionCall.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static FunctionCall fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, FunctionCall.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_FunctionCall.Builder();
        }

        @JsonProperty(value="id")
        public abstract Builder id(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder id(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearId() {
            return this.id(Optional.empty());
        }

        @JsonProperty(value="args")
        public abstract Builder args(Map<String, Object> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder args(Optional<Map<String, Object>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearArgs() {
            return this.args(Optional.empty());
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="partialArgs")
        public abstract Builder partialArgs(List<PartialArg> var1);

        @CanIgnoreReturnValue
        public Builder partialArgs(PartialArg ... partialArgs) {
            return this.partialArgs(Arrays.asList(partialArgs));
        }

        @CanIgnoreReturnValue
        public Builder partialArgs(PartialArg.Builder ... partialArgsBuilders) {
            return this.partialArgs((List)Arrays.asList(partialArgsBuilders).stream().map(PartialArg.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder partialArgs(Optional<List<PartialArg>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPartialArgs() {
            return this.partialArgs(Optional.empty());
        }

        @JsonProperty(value="willContinue")
        public abstract Builder willContinue(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder willContinue(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearWillContinue() {
            return this.willContinue(Optional.empty());
        }

        public abstract FunctionCall build();
    }
}

