/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_File;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.FileSource;
import com.google.genai.types.FileState;
import com.google.genai.types.FileStatus;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class File
extends JsonSerializable {
    @JsonProperty(value="name")
    public abstract Optional<String> name();

    @JsonProperty(value="displayName")
    public abstract Optional<String> displayName();

    @JsonProperty(value="mimeType")
    public abstract Optional<String> mimeType();

    @JsonProperty(value="sizeBytes")
    public abstract Optional<Long> sizeBytes();

    @JsonProperty(value="createTime")
    public abstract Optional<Instant> createTime();

    @JsonProperty(value="expirationTime")
    public abstract Optional<Instant> expirationTime();

    @JsonProperty(value="updateTime")
    public abstract Optional<Instant> updateTime();

    @JsonProperty(value="sha256Hash")
    public abstract Optional<String> sha256Hash();

    @JsonProperty(value="uri")
    public abstract Optional<String> uri();

    @JsonProperty(value="downloadUri")
    public abstract Optional<String> downloadUri();

    @JsonProperty(value="state")
    public abstract Optional<FileState> state();

    @JsonProperty(value="source")
    public abstract Optional<FileSource> source();

    @JsonProperty(value="videoMetadata")
    public abstract Optional<Map<String, Object>> videoMetadata();

    @JsonProperty(value="error")
    public abstract Optional<FileStatus> error();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_File.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static File fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, File.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_File.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder name(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearName() {
            return this.name(Optional.empty());
        }

        @JsonProperty(value="displayName")
        public abstract Builder displayName(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder displayName(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDisplayName() {
            return this.displayName(Optional.empty());
        }

        @JsonProperty(value="mimeType")
        public abstract Builder mimeType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mimeType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMimeType() {
            return this.mimeType(Optional.empty());
        }

        @JsonProperty(value="sizeBytes")
        public abstract Builder sizeBytes(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sizeBytes(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSizeBytes() {
            return this.sizeBytes(Optional.empty());
        }

        @JsonProperty(value="createTime")
        public abstract Builder createTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder createTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCreateTime() {
            return this.createTime(Optional.empty());
        }

        @JsonProperty(value="expirationTime")
        public abstract Builder expirationTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder expirationTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExpirationTime() {
            return this.expirationTime(Optional.empty());
        }

        @JsonProperty(value="updateTime")
        public abstract Builder updateTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder updateTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUpdateTime() {
            return this.updateTime(Optional.empty());
        }

        @JsonProperty(value="sha256Hash")
        public abstract Builder sha256Hash(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sha256Hash(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSha256Hash() {
            return this.sha256Hash(Optional.empty());
        }

        @JsonProperty(value="uri")
        public abstract Builder uri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder uri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUri() {
            return this.uri(Optional.empty());
        }

        @JsonProperty(value="downloadUri")
        public abstract Builder downloadUri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder downloadUri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDownloadUri() {
            return this.downloadUri(Optional.empty());
        }

        @JsonProperty(value="state")
        public abstract Builder state(FileState var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder state(Optional<FileState> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearState() {
            return this.state(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder state(FileState.Known knownType) {
            return this.state(new FileState(knownType));
        }

        @CanIgnoreReturnValue
        public Builder state(String state) {
            return this.state(new FileState(state));
        }

        @JsonProperty(value="source")
        public abstract Builder source(FileSource var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder source(Optional<FileSource> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSource() {
            return this.source(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder source(FileSource.Known knownType) {
            return this.source(new FileSource(knownType));
        }

        @CanIgnoreReturnValue
        public Builder source(String source) {
            return this.source(new FileSource(source));
        }

        @JsonProperty(value="videoMetadata")
        public abstract Builder videoMetadata(Map<String, Object> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder videoMetadata(Optional<Map<String, Object>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVideoMetadata() {
            return this.videoMetadata(Optional.empty());
        }

        @JsonProperty(value="error")
        public abstract Builder error(FileStatus var1);

        @CanIgnoreReturnValue
        public Builder error(FileStatus.Builder errorBuilder) {
            return this.error(errorBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder error(Optional<FileStatus> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearError() {
            return this.error(Optional.empty());
        }

        public abstract File build();
    }
}

