/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_EmbedContentResponse;
import com.google.genai.types.ContentEmbedding;
import com.google.genai.types.EmbedContentMetadata;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EmbedContentResponse
extends JsonSerializable {
    @JsonProperty(value="sdkHttpResponse")
    public abstract Optional<HttpResponse> sdkHttpResponse();

    @JsonProperty(value="embeddings")
    public abstract Optional<List<ContentEmbedding>> embeddings();

    @JsonProperty(value="metadata")
    public abstract Optional<EmbedContentMetadata> metadata();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_EmbedContentResponse.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static EmbedContentResponse fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, EmbedContentResponse.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_EmbedContentResponse.Builder();
        }

        @JsonProperty(value="sdkHttpResponse")
        public abstract Builder sdkHttpResponse(HttpResponse var1);

        @CanIgnoreReturnValue
        public Builder sdkHttpResponse(HttpResponse.Builder sdkHttpResponseBuilder) {
            return this.sdkHttpResponse(sdkHttpResponseBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder sdkHttpResponse(Optional<HttpResponse> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSdkHttpResponse() {
            return this.sdkHttpResponse(Optional.empty());
        }

        @JsonProperty(value="embeddings")
        public abstract Builder embeddings(List<ContentEmbedding> var1);

        @CanIgnoreReturnValue
        public Builder embeddings(ContentEmbedding ... embeddings) {
            return this.embeddings(Arrays.asList(embeddings));
        }

        @CanIgnoreReturnValue
        public Builder embeddings(ContentEmbedding.Builder ... embeddingsBuilders) {
            return this.embeddings((List)Arrays.asList(embeddingsBuilders).stream().map(ContentEmbedding.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder embeddings(Optional<List<ContentEmbedding>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEmbeddings() {
            return this.embeddings(Optional.empty());
        }

        @JsonProperty(value="metadata")
        public abstract Builder metadata(EmbedContentMetadata var1);

        @CanIgnoreReturnValue
        public Builder metadata(EmbedContentMetadata.Builder metadataBuilder) {
            return this.metadata(metadataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder metadata(Optional<EmbedContentMetadata> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMetadata() {
            return this.metadata(Optional.empty());
        }

        public abstract EmbedContentResponse build();
    }
}

