/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_CompletionStats;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class CompletionStats
extends JsonSerializable {
    @JsonProperty(value="failedCount")
    public abstract Optional<Long> failedCount();

    @JsonProperty(value="incompleteCount")
    public abstract Optional<Long> incompleteCount();

    @JsonProperty(value="successfulCount")
    public abstract Optional<Long> successfulCount();

    @JsonProperty(value="successfulForecastPointCount")
    public abstract Optional<Long> successfulForecastPointCount();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_CompletionStats.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static CompletionStats fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, CompletionStats.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_CompletionStats.Builder();
        }

        @JsonProperty(value="failedCount")
        public abstract Builder failedCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder failedCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFailedCount() {
            return this.failedCount(Optional.empty());
        }

        @JsonProperty(value="incompleteCount")
        public abstract Builder incompleteCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder incompleteCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearIncompleteCount() {
            return this.incompleteCount(Optional.empty());
        }

        @JsonProperty(value="successfulCount")
        public abstract Builder successfulCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder successfulCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSuccessfulCount() {
            return this.successfulCount(Optional.empty());
        }

        @JsonProperty(value="successfulForecastPointCount")
        public abstract Builder successfulForecastPointCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder successfulForecastPointCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSuccessfulForecastPointCount() {
            return this.successfulForecastPointCount(Optional.empty());
        }

        public abstract CompletionStats build();
    }
}

