/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_AutomaticActivityDetection;
import com.google.genai.types.EndSensitivity;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.StartSensitivity;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AutomaticActivityDetection
extends JsonSerializable {
    @JsonProperty(value="disabled")
    public abstract Optional<Boolean> disabled();

    @JsonProperty(value="startOfSpeechSensitivity")
    public abstract Optional<StartSensitivity> startOfSpeechSensitivity();

    @JsonProperty(value="endOfSpeechSensitivity")
    public abstract Optional<EndSensitivity> endOfSpeechSensitivity();

    @JsonProperty(value="prefixPaddingMs")
    public abstract Optional<Integer> prefixPaddingMs();

    @JsonProperty(value="silenceDurationMs")
    public abstract Optional<Integer> silenceDurationMs();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_AutomaticActivityDetection.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static AutomaticActivityDetection fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, AutomaticActivityDetection.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_AutomaticActivityDetection.Builder();
        }

        @JsonProperty(value="disabled")
        public abstract Builder disabled(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder disabled(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDisabled() {
            return this.disabled(Optional.empty());
        }

        @JsonProperty(value="startOfSpeechSensitivity")
        public abstract Builder startOfSpeechSensitivity(StartSensitivity var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder startOfSpeechSensitivity(Optional<StartSensitivity> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStartOfSpeechSensitivity() {
            return this.startOfSpeechSensitivity(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder startOfSpeechSensitivity(StartSensitivity.Known knownType) {
            return this.startOfSpeechSensitivity(new StartSensitivity(knownType));
        }

        @CanIgnoreReturnValue
        public Builder startOfSpeechSensitivity(String startOfSpeechSensitivity) {
            return this.startOfSpeechSensitivity(new StartSensitivity(startOfSpeechSensitivity));
        }

        @JsonProperty(value="endOfSpeechSensitivity")
        public abstract Builder endOfSpeechSensitivity(EndSensitivity var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder endOfSpeechSensitivity(Optional<EndSensitivity> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEndOfSpeechSensitivity() {
            return this.endOfSpeechSensitivity(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder endOfSpeechSensitivity(EndSensitivity.Known knownType) {
            return this.endOfSpeechSensitivity(new EndSensitivity(knownType));
        }

        @CanIgnoreReturnValue
        public Builder endOfSpeechSensitivity(String endOfSpeechSensitivity) {
            return this.endOfSpeechSensitivity(new EndSensitivity(endOfSpeechSensitivity));
        }

        @JsonProperty(value="prefixPaddingMs")
        public abstract Builder prefixPaddingMs(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder prefixPaddingMs(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPrefixPaddingMs() {
            return this.prefixPaddingMs(Optional.empty());
        }

        @JsonProperty(value="silenceDurationMs")
        public abstract Builder silenceDurationMs(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder silenceDurationMs(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSilenceDurationMs() {
            return this.silenceDurationMs(Optional.empty());
        }

        public abstract AutomaticActivityDetection build();
    }
}

