/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.FunctionCallingConfig;
import com.google.genai.types.RetrievalConfig;
import com.google.genai.types.ToolConfig;
import java.util.Optional;

final class AutoValue_ToolConfig
extends ToolConfig {
    private final Optional<RetrievalConfig> retrievalConfig;
    private final Optional<FunctionCallingConfig> functionCallingConfig;

    private AutoValue_ToolConfig(Optional<RetrievalConfig> retrievalConfig, Optional<FunctionCallingConfig> functionCallingConfig) {
        this.retrievalConfig = retrievalConfig;
        this.functionCallingConfig = functionCallingConfig;
    }

    @Override
    @JsonProperty(value="retrievalConfig")
    public Optional<RetrievalConfig> retrievalConfig() {
        return this.retrievalConfig;
    }

    @Override
    @JsonProperty(value="functionCallingConfig")
    public Optional<FunctionCallingConfig> functionCallingConfig() {
        return this.functionCallingConfig;
    }

    public String toString() {
        return "ToolConfig{retrievalConfig=" + this.retrievalConfig + ", functionCallingConfig=" + this.functionCallingConfig + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ToolConfig) {
            ToolConfig that = (ToolConfig)o;
            return this.retrievalConfig.equals(that.retrievalConfig()) && this.functionCallingConfig.equals(that.functionCallingConfig());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.retrievalConfig.hashCode();
        h$ *= 1000003;
        return h$ ^= this.functionCallingConfig.hashCode();
    }

    @Override
    public ToolConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ToolConfig.Builder {
        private Optional<RetrievalConfig> retrievalConfig = Optional.empty();
        private Optional<FunctionCallingConfig> functionCallingConfig = Optional.empty();

        Builder() {
        }

        Builder(ToolConfig source) {
            this.retrievalConfig = source.retrievalConfig();
            this.functionCallingConfig = source.functionCallingConfig();
        }

        @Override
        public ToolConfig.Builder retrievalConfig(RetrievalConfig retrievalConfig) {
            this.retrievalConfig = Optional.of(retrievalConfig);
            return this;
        }

        @Override
        ToolConfig.Builder retrievalConfig(Optional<RetrievalConfig> retrievalConfig) {
            if (retrievalConfig == null) {
                throw new NullPointerException("Null retrievalConfig");
            }
            this.retrievalConfig = retrievalConfig;
            return this;
        }

        @Override
        public ToolConfig.Builder functionCallingConfig(FunctionCallingConfig functionCallingConfig) {
            this.functionCallingConfig = Optional.of(functionCallingConfig);
            return this;
        }

        @Override
        ToolConfig.Builder functionCallingConfig(Optional<FunctionCallingConfig> functionCallingConfig) {
            if (functionCallingConfig == null) {
                throw new NullPointerException("Null functionCallingConfig");
            }
            this.functionCallingConfig = functionCallingConfig;
            return this;
        }

        @Override
        public ToolConfig build() {
            return new AutoValue_ToolConfig(this.retrievalConfig, this.functionCallingConfig);
        }
    }
}

