/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.SegmentImageConfig;
import com.google.genai.types.SegmentMode;
import java.util.Map;
import java.util.Optional;

final class AutoValue_SegmentImageConfig
extends SegmentImageConfig {
    private final Optional<HttpOptions> httpOptions;
    private final Optional<SegmentMode> mode;
    private final Optional<Integer> maxPredictions;
    private final Optional<Float> confidenceThreshold;
    private final Optional<Float> maskDilation;
    private final Optional<Float> binaryColorThreshold;
    private final Optional<Map<String, String>> labels;

    private AutoValue_SegmentImageConfig(Optional<HttpOptions> httpOptions, Optional<SegmentMode> mode, Optional<Integer> maxPredictions, Optional<Float> confidenceThreshold, Optional<Float> maskDilation, Optional<Float> binaryColorThreshold, Optional<Map<String, String>> labels) {
        this.httpOptions = httpOptions;
        this.mode = mode;
        this.maxPredictions = maxPredictions;
        this.confidenceThreshold = confidenceThreshold;
        this.maskDilation = maskDilation;
        this.binaryColorThreshold = binaryColorThreshold;
        this.labels = labels;
    }

    @Override
    @JsonProperty(value="httpOptions")
    public Optional<HttpOptions> httpOptions() {
        return this.httpOptions;
    }

    @Override
    @JsonProperty(value="mode")
    public Optional<SegmentMode> mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="maxPredictions")
    public Optional<Integer> maxPredictions() {
        return this.maxPredictions;
    }

    @Override
    @JsonProperty(value="confidenceThreshold")
    public Optional<Float> confidenceThreshold() {
        return this.confidenceThreshold;
    }

    @Override
    @JsonProperty(value="maskDilation")
    public Optional<Float> maskDilation() {
        return this.maskDilation;
    }

    @Override
    @JsonProperty(value="binaryColorThreshold")
    public Optional<Float> binaryColorThreshold() {
        return this.binaryColorThreshold;
    }

    @Override
    @JsonProperty(value="labels")
    public Optional<Map<String, String>> labels() {
        return this.labels;
    }

    public String toString() {
        return "SegmentImageConfig{httpOptions=" + this.httpOptions + ", mode=" + this.mode + ", maxPredictions=" + this.maxPredictions + ", confidenceThreshold=" + this.confidenceThreshold + ", maskDilation=" + this.maskDilation + ", binaryColorThreshold=" + this.binaryColorThreshold + ", labels=" + this.labels + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SegmentImageConfig) {
            SegmentImageConfig that = (SegmentImageConfig)o;
            return this.httpOptions.equals(that.httpOptions()) && this.mode.equals(that.mode()) && this.maxPredictions.equals(that.maxPredictions()) && this.confidenceThreshold.equals(that.confidenceThreshold()) && this.maskDilation.equals(that.maskDilation()) && this.binaryColorThreshold.equals(that.binaryColorThreshold()) && this.labels.equals(that.labels());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.httpOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.mode.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxPredictions.hashCode();
        h$ *= 1000003;
        h$ ^= this.confidenceThreshold.hashCode();
        h$ *= 1000003;
        h$ ^= this.maskDilation.hashCode();
        h$ *= 1000003;
        h$ ^= this.binaryColorThreshold.hashCode();
        h$ *= 1000003;
        return h$ ^= this.labels.hashCode();
    }

    @Override
    public SegmentImageConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SegmentImageConfig.Builder {
        private Optional<HttpOptions> httpOptions = Optional.empty();
        private Optional<SegmentMode> mode = Optional.empty();
        private Optional<Integer> maxPredictions = Optional.empty();
        private Optional<Float> confidenceThreshold = Optional.empty();
        private Optional<Float> maskDilation = Optional.empty();
        private Optional<Float> binaryColorThreshold = Optional.empty();
        private Optional<Map<String, String>> labels = Optional.empty();

        Builder() {
        }

        Builder(SegmentImageConfig source) {
            this.httpOptions = source.httpOptions();
            this.mode = source.mode();
            this.maxPredictions = source.maxPredictions();
            this.confidenceThreshold = source.confidenceThreshold();
            this.maskDilation = source.maskDilation();
            this.binaryColorThreshold = source.binaryColorThreshold();
            this.labels = source.labels();
        }

        @Override
        public SegmentImageConfig.Builder httpOptions(HttpOptions httpOptions) {
            this.httpOptions = Optional.of(httpOptions);
            return this;
        }

        @Override
        SegmentImageConfig.Builder httpOptions(Optional<HttpOptions> httpOptions) {
            if (httpOptions == null) {
                throw new NullPointerException("Null httpOptions");
            }
            this.httpOptions = httpOptions;
            return this;
        }

        @Override
        public SegmentImageConfig.Builder mode(SegmentMode mode) {
            this.mode = Optional.of(mode);
            return this;
        }

        @Override
        SegmentImageConfig.Builder mode(Optional<SegmentMode> mode) {
            if (mode == null) {
                throw new NullPointerException("Null mode");
            }
            this.mode = mode;
            return this;
        }

        @Override
        public SegmentImageConfig.Builder maxPredictions(Integer maxPredictions) {
            this.maxPredictions = Optional.of(maxPredictions);
            return this;
        }

        @Override
        SegmentImageConfig.Builder maxPredictions(Optional<Integer> maxPredictions) {
            if (maxPredictions == null) {
                throw new NullPointerException("Null maxPredictions");
            }
            this.maxPredictions = maxPredictions;
            return this;
        }

        @Override
        public SegmentImageConfig.Builder confidenceThreshold(Float confidenceThreshold) {
            this.confidenceThreshold = Optional.of(confidenceThreshold);
            return this;
        }

        @Override
        SegmentImageConfig.Builder confidenceThreshold(Optional<Float> confidenceThreshold) {
            if (confidenceThreshold == null) {
                throw new NullPointerException("Null confidenceThreshold");
            }
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        @Override
        public SegmentImageConfig.Builder maskDilation(Float maskDilation) {
            this.maskDilation = Optional.of(maskDilation);
            return this;
        }

        @Override
        SegmentImageConfig.Builder maskDilation(Optional<Float> maskDilation) {
            if (maskDilation == null) {
                throw new NullPointerException("Null maskDilation");
            }
            this.maskDilation = maskDilation;
            return this;
        }

        @Override
        public SegmentImageConfig.Builder binaryColorThreshold(Float binaryColorThreshold) {
            this.binaryColorThreshold = Optional.of(binaryColorThreshold);
            return this;
        }

        @Override
        SegmentImageConfig.Builder binaryColorThreshold(Optional<Float> binaryColorThreshold) {
            if (binaryColorThreshold == null) {
                throw new NullPointerException("Null binaryColorThreshold");
            }
            this.binaryColorThreshold = binaryColorThreshold;
            return this;
        }

        @Override
        public SegmentImageConfig.Builder labels(Map<String, String> labels) {
            this.labels = Optional.of(labels);
            return this;
        }

        @Override
        SegmentImageConfig.Builder labels(Optional<Map<String, String>> labels) {
            if (labels == null) {
                throw new NullPointerException("Null labels");
            }
            this.labels = labels;
            return this;
        }

        @Override
        public SegmentImageConfig build() {
            return new AutoValue_SegmentImageConfig(this.httpOptions, this.mode, this.maxPredictions, this.confidenceThreshold, this.maskDilation, this.binaryColorThreshold, this.labels);
        }
    }
}

