/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.BatchJobSource;
import com.google.genai.types.InlinedRequest;
import java.util.List;
import java.util.Optional;

final class AutoValue_BatchJobSource
extends BatchJobSource {
    private final Optional<String> format;
    private final Optional<List<String>> gcsUri;
    private final Optional<String> bigqueryUri;
    private final Optional<String> fileName;
    private final Optional<List<InlinedRequest>> inlinedRequests;

    private AutoValue_BatchJobSource(Optional<String> format, Optional<List<String>> gcsUri, Optional<String> bigqueryUri, Optional<String> fileName, Optional<List<InlinedRequest>> inlinedRequests) {
        this.format = format;
        this.gcsUri = gcsUri;
        this.bigqueryUri = bigqueryUri;
        this.fileName = fileName;
        this.inlinedRequests = inlinedRequests;
    }

    @Override
    @JsonProperty(value="format")
    public Optional<String> format() {
        return this.format;
    }

    @Override
    @JsonProperty(value="gcsUri")
    public Optional<List<String>> gcsUri() {
        return this.gcsUri;
    }

    @Override
    @JsonProperty(value="bigqueryUri")
    public Optional<String> bigqueryUri() {
        return this.bigqueryUri;
    }

    @Override
    @JsonProperty(value="fileName")
    public Optional<String> fileName() {
        return this.fileName;
    }

    @Override
    @JsonProperty(value="inlinedRequests")
    public Optional<List<InlinedRequest>> inlinedRequests() {
        return this.inlinedRequests;
    }

    public String toString() {
        return "BatchJobSource{format=" + this.format + ", gcsUri=" + this.gcsUri + ", bigqueryUri=" + this.bigqueryUri + ", fileName=" + this.fileName + ", inlinedRequests=" + this.inlinedRequests + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BatchJobSource) {
            BatchJobSource that = (BatchJobSource)o;
            return this.format.equals(that.format()) && this.gcsUri.equals(that.gcsUri()) && this.bigqueryUri.equals(that.bigqueryUri()) && this.fileName.equals(that.fileName()) && this.inlinedRequests.equals(that.inlinedRequests());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.gcsUri.hashCode();
        h$ *= 1000003;
        h$ ^= this.bigqueryUri.hashCode();
        h$ *= 1000003;
        h$ ^= this.fileName.hashCode();
        h$ *= 1000003;
        return h$ ^= this.inlinedRequests.hashCode();
    }

    @Override
    public BatchJobSource.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends BatchJobSource.Builder {
        private Optional<String> format = Optional.empty();
        private Optional<List<String>> gcsUri = Optional.empty();
        private Optional<String> bigqueryUri = Optional.empty();
        private Optional<String> fileName = Optional.empty();
        private Optional<List<InlinedRequest>> inlinedRequests = Optional.empty();

        Builder() {
        }

        Builder(BatchJobSource source) {
            this.format = source.format();
            this.gcsUri = source.gcsUri();
            this.bigqueryUri = source.bigqueryUri();
            this.fileName = source.fileName();
            this.inlinedRequests = source.inlinedRequests();
        }

        @Override
        public BatchJobSource.Builder format(String format) {
            this.format = Optional.of(format);
            return this;
        }

        @Override
        BatchJobSource.Builder format(Optional<String> format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public BatchJobSource.Builder gcsUri(List<String> gcsUri) {
            this.gcsUri = Optional.of(gcsUri);
            return this;
        }

        @Override
        BatchJobSource.Builder gcsUri(Optional<List<String>> gcsUri) {
            if (gcsUri == null) {
                throw new NullPointerException("Null gcsUri");
            }
            this.gcsUri = gcsUri;
            return this;
        }

        @Override
        public BatchJobSource.Builder bigqueryUri(String bigqueryUri) {
            this.bigqueryUri = Optional.of(bigqueryUri);
            return this;
        }

        @Override
        BatchJobSource.Builder bigqueryUri(Optional<String> bigqueryUri) {
            if (bigqueryUri == null) {
                throw new NullPointerException("Null bigqueryUri");
            }
            this.bigqueryUri = bigqueryUri;
            return this;
        }

        @Override
        public BatchJobSource.Builder fileName(String fileName) {
            this.fileName = Optional.of(fileName);
            return this;
        }

        @Override
        BatchJobSource.Builder fileName(Optional<String> fileName) {
            if (fileName == null) {
                throw new NullPointerException("Null fileName");
            }
            this.fileName = fileName;
            return this;
        }

        @Override
        public BatchJobSource.Builder inlinedRequests(List<InlinedRequest> inlinedRequests) {
            this.inlinedRequests = Optional.of(inlinedRequests);
            return this;
        }

        @Override
        BatchJobSource.Builder inlinedRequests(Optional<List<InlinedRequest>> inlinedRequests) {
            if (inlinedRequests == null) {
                throw new NullPointerException("Null inlinedRequests");
            }
            this.inlinedRequests = inlinedRequests;
            return this;
        }

        @Override
        public BatchJobSource build() {
            return new AutoValue_BatchJobSource(this.format, this.gcsUri, this.bigqueryUri, this.fileName, this.inlinedRequests);
        }
    }
}

