/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Transformers;

final class TokensConverters {
    private final ApiClient apiClient;

    public TokensConverters(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createAuthTokenConfigToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"newSessionExpireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"newSessionExpireTime"}, Common.getValueByPath(fromObject, new String[]{"newSessionExpireTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"uses"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"uses"}, Common.getValueByPath(fromObject, new String[]{"uses"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"liveConnectConstraints"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"bidiGenerateContentSetup"}, this.liveConnectConstraintsToMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"liveConnectConstraints"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"lockAdditionalFields"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"fieldMask"}, Common.getValueByPath(fromObject, new String[]{"lockAdditionalFields"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createAuthTokenParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.createAuthTokenConfigToMldev(apiClient, JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createAuthTokenParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"config"}))) {
            throw new IllegalArgumentException("config parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"id"}) != null) {
            Common.setValueByPath(toObject, new String[]{"id"}, Common.getValueByPath(fromObject, new String[]{"id"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"args"}) != null) {
            Common.setValueByPath(toObject, new String[]{"args"}, Common.getValueByPath(fromObject, new String[]{"args"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"partialArgs"}))) {
            throw new IllegalArgumentException("partialArgs parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"willContinue"}))) {
            throw new IllegalArgumentException("willContinue parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"authConfig"}))) {
            throw new IllegalArgumentException("authConfig parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"enableWidget"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enableWidget"}, Common.getValueByPath(fromObject, new String[]{"enableWidget"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"excludeDomains"}))) {
            throw new IllegalArgumentException("excludeDomains parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"blockingConfidence"}))) {
            throw new IllegalArgumentException("blockingConfidence parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode liveConnectConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"responseModalities"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "responseModalities"}, Common.getValueByPath(fromObject, new String[]{"responseModalities"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"temperature"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "temperature"}, Common.getValueByPath(fromObject, new String[]{"temperature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topP"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "topP"}, Common.getValueByPath(fromObject, new String[]{"topP"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"topK"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "topK"}, Common.getValueByPath(fromObject, new String[]{"topK"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "maxOutputTokens"}, Common.getValueByPath(fromObject, new String[]{"maxOutputTokens"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mediaResolution"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "mediaResolution"}, Common.getValueByPath(fromObject, new String[]{"mediaResolution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"seed"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "seed"}, Common.getValueByPath(fromObject, new String[]{"seed"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"speechConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "speechConfig"}, Transformers.tLiveSpeechConfig(Common.getValueByPath(fromObject, new String[]{"speechConfig"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thinkingConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "thinkingConfig"}, Common.getValueByPath(fromObject, new String[]{"thinkingConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enableAffectiveDialog"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "generationConfig", "enableAffectiveDialog"}, Common.getValueByPath(fromObject, new String[]{"enableAffectiveDialog"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "systemInstruction"}, this.contentToMldev(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath(fromObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"tools"}) != null) {
            ArrayNode keyArray = (ArrayNode)Transformers.tTools(Common.getValueByPath(fromObject, new String[]{"tools"}));
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolToMldev(JsonSerializable.toJsonNode(Transformers.tTool(item)), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"setup", "tools"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"sessionResumption"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "sessionResumption"}, this.sessionResumptionConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"sessionResumption"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inputAudioTranscription"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "inputAudioTranscription"}, Common.getValueByPath(fromObject, new String[]{"inputAudioTranscription"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"outputAudioTranscription"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "outputAudioTranscription"}, Common.getValueByPath(fromObject, new String[]{"outputAudioTranscription"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"realtimeInputConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "realtimeInputConfig"}, Common.getValueByPath(fromObject, new String[]{"realtimeInputConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"contextWindowCompression"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "contextWindowCompression"}, Common.getValueByPath(fromObject, new String[]{"contextWindowCompression"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"proactivity"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"setup", "proactivity"}, Common.getValueByPath(fromObject, new String[]{"proactivity"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"explicitVadSignal"}))) {
            throw new IllegalArgumentException("explicitVadSignal parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode liveConnectConstraintsToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"setup", "model"}, Transformers.tModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            Common.setValueByPath(toObject, new String[]{"config"}, this.liveConnectConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mediaResolution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mediaResolution"}, Common.getValueByPath(fromObject, new String[]{"mediaResolution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, this.functionCallToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCall"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, Common.getValueByPath(fromObject, new String[]{"videoMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode sessionResumptionConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"handle"}) != null) {
            Common.setValueByPath(toObject, new String[]{"handle"}, Common.getValueByPath(fromObject, new String[]{"handle"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"transparent"}))) {
            throw new IllegalArgumentException("transparent parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"retrieval"}))) {
            throw new IllegalArgumentException("retrieval parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"computerUse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"computerUse"}, Common.getValueByPath(fromObject, new String[]{"computerUse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileSearch"}, Common.getValueByPath(fromObject, new String[]{"fileSearch"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}))) {
            throw new IllegalArgumentException("enterpriseWebSearch parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleMaps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleMaps"}, this.googleMapsToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleMaps"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, Common.getValueByPath(fromObject, new String[]{"urlContext"}));
        }
        return toObject;
    }
}

