/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.core.InternalApi;
import com.google.genai.ApiClient;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Transformers;

@InternalApi
public final class OperationsConverters {
    private final ApiClient apiClient;

    public OperationsConverters(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode fetchPredictOperationParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"operationName"}))) {
            throw new IllegalArgumentException("operationName parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"resourceName"}))) {
            throw new IllegalArgumentException("resourceName parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"config"}))) {
            throw new IllegalArgumentException("config parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode fetchPredictOperationParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"resourceName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "resourceName"}, Common.getValueByPath(fromObject, new String[]{"resourceName"}));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode generateVideosOperationFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response", "generateVideoResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateVideosResponseFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response", "generateVideoResponse"})), toObject));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode generateVideosOperationFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateVideosResponseFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode generateVideosResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"generatedSamples"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"generatedSamples"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.generatedVideoFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"generatedVideos"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredCount"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredReasons"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode generateVideosResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videos"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"videos"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.generatedVideoFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"generatedVideos"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredCount"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredReasons"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode generatedVideoFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"video"}) != null) {
            Common.setValueByPath(toObject, new String[]{"video"}, this.videoFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"video"})), toObject));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode generatedVideoFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"_self"}) != null) {
            Common.setValueByPath(toObject, new String[]{"video"}, this.videoFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"_self"})), toObject));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode getOperationParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode getOperationParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode importFileOperationFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.importFileResponseFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode importFileResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parent"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parent"}, Common.getValueByPath(fromObject, new String[]{"parent"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"documentName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"documentName"}, Common.getValueByPath(fromObject, new String[]{"documentName"}));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode uploadToFileSearchStoreOperationFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.uploadToFileSearchStoreResponseFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode uploadToFileSearchStoreResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parent"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parent"}, Common.getValueByPath(fromObject, new String[]{"parent"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"documentName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"documentName"}, Common.getValueByPath(fromObject, new String[]{"documentName"}));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode videoFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"uri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"uri"}, Common.getValueByPath(fromObject, new String[]{"uri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"encodedVideo"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoBytes"}, Transformers.tBytes(Common.getValueByPath(fromObject, new String[]{"encodedVideo"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"encoding"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"encoding"}));
        }
        return toObject;
    }

    @InternalApi
    @ExcludeFromGeneratedCoverageReport
    public ObjectNode videoFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"gcsUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"uri"}, Common.getValueByPath(fromObject, new String[]{"gcsUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bytesBase64Encoded"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoBytes"}, Transformers.tBytes(Common.getValueByPath(fromObject, new String[]{"bytesBase64Encoded"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }
}

