/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.FetchPredictOperationConfig;
import com.google.genai.types.FetchPredictOperationParameters;
import com.google.genai.types.GenerateVideosOperation;
import com.google.genai.types.GetOperationConfig;
import com.google.genai.types.GetOperationParameters;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.Operation;
import java.io.IOException;
import java.util.Optional;
import okhttp3.ResponseBody;

public final class Operations {
    final ApiClient apiClient;

    public Operations(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fetchPredictOperationParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"resourceName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "resourceName"}, Common.getValueByPath(fromObject, new String[]{"resourceName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateVideosOperationFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response", "generateVideoResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateVideosResponseFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response", "generateVideoResponse"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateVideosOperationFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"metadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"metadata"}, Common.getValueByPath(fromObject, new String[]{"metadata"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"done"}) != null) {
            Common.setValueByPath(toObject, new String[]{"done"}, Common.getValueByPath(fromObject, new String[]{"done"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"error"}) != null) {
            Common.setValueByPath(toObject, new String[]{"error"}, Common.getValueByPath(fromObject, new String[]{"error"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, this.generateVideosResponseFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"response"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateVideosResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"generatedSamples"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"generatedSamples"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.generatedVideoFromMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"generatedVideos"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredCount"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredReasons"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generateVideosResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"videos"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"videos"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.generatedVideoFromVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"generatedVideos"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredCount"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredCount"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}) != null) {
            Common.setValueByPath(toObject, new String[]{"raiMediaFilteredReasons"}, Common.getValueByPath(fromObject, new String[]{"raiMediaFilteredReasons"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generatedVideoFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"video"}) != null) {
            Common.setValueByPath(toObject, new String[]{"video"}, this.videoFromMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"video"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode generatedVideoFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"_self"}) != null) {
            Common.setValueByPath(toObject, new String[]{"video"}, this.videoFromVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"_self"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getOperationParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getOperationParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"operationName"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "operationName"}, Common.getValueByPath(fromObject, new String[]{"operationName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"uri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"uri"}, Common.getValueByPath(fromObject, new String[]{"uri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"encodedVideo"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoBytes"}, Transformers.tBytes(Common.getValueByPath(fromObject, new String[]{"encodedVideo"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"encoding"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"encoding"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode videoFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"gcsUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"uri"}, Common.getValueByPath(fromObject, new String[]{"gcsUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"bytesBase64Encoded"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoBytes"}, Transformers.tBytes(Common.getValueByPath(fromObject, new String[]{"bytesBase64Encoded"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    Common.BuiltRequest buildRequestForPrivateGetVideosOperation(String operationName, GetOperationConfig config) {
        String path;
        ObjectNode body;
        GetOperationParameters.Builder parameterBuilder = GetOperationParameters.builder();
        if (!Common.isZero(operationName)) {
            parameterBuilder.operationName(operationName);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.getOperationParametersToVertex(parameterNode, null);
            path = Common.formatMap("{operationName}", body.get("_url"));
        } else {
            body = this.getOperationParametersToMldev(parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{operationName}", body.get("_url")) : "{operationName}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    JsonNode processResponseForPrivateGetVideosOperation(ApiResponse response, GetOperationConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        return JsonSerializable.stringToJsonNode(responseString);
    }

    JsonNode privateGetVideosOperation(String operationName, GetOperationConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateGetVideosOperation(operationName, config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            JsonNode jsonNode = this.processResponseForPrivateGetVideosOperation(response, config);
            return jsonNode;
        }
    }

    Common.BuiltRequest buildRequestForPrivateFetchPredictVideosOperation(String operationName, String resourceName, FetchPredictOperationConfig config) {
        FetchPredictOperationParameters.Builder parameterBuilder = FetchPredictOperationParameters.builder();
        if (!Common.isZero(operationName)) {
            parameterBuilder.operationName(operationName);
        }
        if (!Common.isZero(resourceName)) {
            parameterBuilder.resourceName(resourceName);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (!this.apiClient.vertexAI()) {
            throw new UnsupportedOperationException("This method is only supported in the Vertex AI client.");
        }
        ObjectNode body = this.fetchPredictOperationParametersToVertex(parameterNode, null);
        String path = Common.formatMap("{resourceName}:fetchPredictOperation", body.get("_url"));
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    JsonNode processResponseForPrivateFetchPredictVideosOperation(ApiResponse response, FetchPredictOperationConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        return JsonSerializable.stringToJsonNode(responseString);
    }

    JsonNode privateFetchPredictVideosOperation(String operationName, String resourceName, FetchPredictOperationConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateFetchPredictVideosOperation(operationName, resourceName, config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            JsonNode jsonNode = this.processResponseForPrivateFetchPredictVideosOperation(response, config);
            return jsonNode;
        }
    }

    public GenerateVideosOperation getVideosOperation(GenerateVideosOperation operation, GetOperationConfig config) {
        return this.get(operation, config);
    }

    public <T, U extends Operation<T, U>> U get(U operation, GetOperationConfig config) {
        if (!operation.name().isPresent()) {
            throw new IllegalArgumentException("Operation name is required.");
        }
        if (this.apiClient.vertexAI()) {
            String resourceName = operation.name().get().split("/operations/")[0];
            JsonNode response = this.privateFetchPredictVideosOperation(operation.name().get(), resourceName, null);
            return operation.fromApiResponse(response, true);
        }
        JsonNode response = this.privateGetVideosOperation(operation.name().get(), config);
        return operation.fromApiResponse(response, false);
    }
}

