/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.api.core.InternalApi;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.HttpApiResponse;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.ClientOptions;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;

@InternalApi
public class HttpApiClient
extends ApiClient {
    public HttpApiClient(Optional<String> apiKey, Optional<HttpOptions> httpOptions, Optional<ClientOptions> clientOptions) {
        super(apiKey, httpOptions, clientOptions);
    }

    public HttpApiClient(Optional<String> apiKey, Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions, Optional<ClientOptions> clientOptions) {
        super(apiKey, project, location, credentials, httpOptions, clientOptions);
    }

    @Override
    public HttpApiResponse request(String httpMethod, String path, String requestJson, Optional<HttpOptions> requestHttpOptions) {
        return this.executeRequest(this.buildRequest(httpMethod, path, requestJson, requestHttpOptions));
    }

    @Override
    public HttpApiResponse request(String httpMethod, String url, byte[] requestBytes, Optional<HttpOptions> requestHttpOptions) {
        return this.executeRequest(this.buildRequest(httpMethod, url, requestBytes, requestHttpOptions));
    }

    private HttpApiResponse executeRequest(Request request) {
        try {
            return new HttpApiResponse(this.httpClient.newCall(request).execute());
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to execute HTTP request.", e);
        }
    }

    @Override
    public CompletableFuture<ApiResponse> asyncRequest(String httpMethod, String path, String requestJson, Optional<HttpOptions> requestHttpOptions) {
        return this.asyncExecuteRequest(this.buildRequest(httpMethod, path, requestJson, requestHttpOptions));
    }

    @Override
    public CompletableFuture<ApiResponse> asyncRequest(String httpMethod, String url, byte[] requestBytes, Optional<HttpOptions> requestHttpOptions) {
        return this.asyncExecuteRequest(this.buildRequest(httpMethod, url, requestBytes, requestHttpOptions));
    }

    private CompletableFuture<ApiResponse> asyncExecuteRequest(Request request) {
        final CompletableFuture<ApiResponse> future = new CompletableFuture<ApiResponse>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(new GenAiIOException("Failed to execute HTTP request.", e));
            }

            public void onResponse(Call call, Response response) {
                future.complete(new HttpApiResponse(response));
            }
        });
        return future;
    }
}

