/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.core.InternalApi;
import com.google.genai.JsonSerializable;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.HttpOptions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.jspecify.annotations.Nullable;

@InternalApi
public final class Common {
    private Common() {
    }

    public static void setValueByPath(ObjectNode jsonObject, String[] path, Object value) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("Path cannot be empty.");
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("JsonObject cannot be null.");
        }
        ObjectNode currentObject = jsonObject;
        for (int i = 0; i < path.length - 1; ++i) {
            String keyName;
            String key = path[i];
            if (key.endsWith("[]")) {
                keyName = key.substring(0, key.length() - 2);
                if (!currentObject.has(keyName)) {
                    currentObject.putArray(keyName);
                }
                ArrayNode arrayNode = (ArrayNode)currentObject.get(keyName);
                if (value instanceof List) {
                    int j;
                    List listValue = (List)value;
                    if (arrayNode.size() != listValue.size()) {
                        arrayNode.removeAll();
                        for (j = 0; j < listValue.size(); ++j) {
                            arrayNode.addObject();
                        }
                    }
                    for (j = 0; j < arrayNode.size(); ++j) {
                        Common.setValueByPath((ObjectNode)arrayNode.get(j), Arrays.copyOfRange(path, i + 1, path.length), listValue.get(j));
                    }
                } else {
                    if (arrayNode.size() == 0) {
                        arrayNode.addObject();
                    }
                    for (int j = 0; j < arrayNode.size(); ++j) {
                        Common.setValueByPath((ObjectNode)arrayNode.get(j), Arrays.copyOfRange(path, i + 1, path.length), value);
                    }
                }
                return;
            }
            if (key.endsWith("[0]")) {
                keyName = key.substring(0, key.length() - 3);
                if (!currentObject.has(keyName)) {
                    currentObject.putArray(keyName).addObject();
                }
                currentObject = (ObjectNode)((ArrayNode)currentObject.get(keyName)).get(0);
                continue;
            }
            if (!currentObject.has(key)) {
                currentObject.putObject(key);
            }
            currentObject = (ObjectNode)currentObject.get(key);
        }
        String keyToSet = path[path.length - 1];
        if (keyToSet.equals("_self") && value instanceof ObjectNode) {
            ObjectNode sourceNode = (ObjectNode)value;
            currentObject.setAll(sourceNode);
        } else {
            JsonNode valueNode = JsonSerializable.toJsonNode(value);
            Transformers.updateJsonNode(currentObject, keyToSet, valueNode);
        }
    }

    public static @Nullable Object getValueByPath(JsonNode object, String[] keys) {
        return Common.getValueByPath(object, keys, null);
    }

    public static @Nullable Object getValueByPath(JsonNode object, String[] keys, @Nullable Object defaultValue) {
        if (object == null || keys == null) {
            return defaultValue;
        }
        if (keys.length == 1 && keys[0].equals("_self")) {
            return object;
        }
        JsonNode currentObject = object;
        for (int i = 0; i < keys.length; ++i) {
            String keyName;
            String key = keys[i];
            if (currentObject == null) {
                return defaultValue;
            }
            if (key.endsWith("[]")) {
                keyName = key.substring(0, key.length() - 2);
                if (currentObject.isObject() && ((ObjectNode)currentObject).has(keyName) && ((ObjectNode)currentObject).get(keyName).isArray()) {
                    ArrayNode arrayNode = (ArrayNode)((ObjectNode)currentObject).get(keyName);
                    if (keys.length - 1 == i) {
                        return arrayNode;
                    }
                    ArrayNode result = JsonSerializable.objectMapper().createArrayNode();
                    for (JsonNode element : arrayNode) {
                        JsonNode node = (JsonNode)Common.getValueByPath(element, Arrays.copyOfRange(keys, i + 1, keys.length), defaultValue);
                        if (node == null) continue;
                        result.add(node);
                    }
                    return result;
                }
                return defaultValue;
            }
            if (key.endsWith("[0]")) {
                keyName = key.substring(0, key.length() - 3);
                if (currentObject.isObject() && ((ObjectNode)currentObject).has(keyName) && ((ObjectNode)currentObject).get(keyName).isArray() && ((ArrayNode)((ObjectNode)currentObject).get(keyName)).size() > 0) {
                    currentObject = ((ArrayNode)((ObjectNode)currentObject).get(keyName)).get(0);
                    continue;
                }
                return defaultValue;
            }
            if (currentObject.isObject() && ((ObjectNode)currentObject).has(key)) {
                currentObject = ((ObjectNode)currentObject).get(key);
                continue;
            }
            return defaultValue;
        }
        return currentObject;
    }

    public static String formatMap(String template, JsonNode data) {
        if (data == null) {
            return template;
        }
        Iterator fields = data.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String key = (String)field.getKey();
            String placeholder = "{" + key + "}";
            if (!template.contains(placeholder)) continue;
            template = template.replace(placeholder, data.get(key).asText());
        }
        return template;
    }

    public static boolean isZero(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Number) {
            Number num = (Number)obj;
            return num.doubleValue() == 0.0;
        }
        if (obj instanceof Character) {
            Character ch = (Character)obj;
            return ch.charValue() == '\u0000';
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return bool == false;
        }
        return false;
    }

    public static String urlEncode(ObjectNode paramsNode) {
        if (paramsNode == null || paramsNode.size() == 0) {
            return "";
        }
        StringJoiner queryBuilder = new StringJoiner("&");
        String utf8 = StandardCharsets.UTF_8.name();
        try {
            Iterator fields = paramsNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String encodedKey = URLEncoder.encode((String)entry.getKey(), utf8);
                JsonNode valueNode = (JsonNode)entry.getValue();
                if (valueNode.isNull()) {
                    queryBuilder.add(encodedKey + "=");
                    continue;
                }
                String encodedValue = URLEncoder.encode(valueNode.asText(""), utf8).replace("*", "%2A");
                queryBuilder.add(encodedKey + "=" + encodedValue);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new GenAiIOException("UTF-8 encoding not supported", e);
        }
        return queryBuilder.toString();
    }

    public static String snakeToCamel(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        boolean capitalizeNext = false;
        for (char c : str.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            sb.append(capitalizeNext ? Character.toUpperCase(c) : c);
            capitalizeNext = false;
        }
        return sb.toString();
    }

    public static void moveValueByPath(JsonNode data, Map<String, String> paths) {
        if (data == null || paths == null) {
            return;
        }
        for (Map.Entry<String, String> entry : paths.entrySet()) {
            int i;
            String sourcePath = entry.getKey();
            String destPath = entry.getValue();
            String[] sourceKeys = sourcePath.split("\\.");
            String[] destKeys = destPath.split("\\.");
            HashSet<String> excludeKeys = new HashSet<String>();
            int wildcardIdx = -1;
            for (i = 0; i < sourceKeys.length; ++i) {
                if (!sourceKeys[i].equals("*")) continue;
                wildcardIdx = i;
                break;
            }
            if (wildcardIdx != -1 && destKeys.length > wildcardIdx) {
                for (i = wildcardIdx; i < destKeys.length; ++i) {
                    String key = destKeys[i];
                    if (key.equals("*") || key.endsWith("[]") || key.endsWith("[0]")) continue;
                    excludeKeys.add(key);
                }
            }
            Common.moveValueRecursive(data, sourceKeys, destKeys, 0, excludeKeys);
        }
    }

    public static void moveValueRecursive(JsonNode data, String[] sourceKeys, String[] destKeys, int keyIdx, Set<String> excludeKeys) {
        if (keyIdx >= sourceKeys.length || data == null) {
            return;
        }
        String key = sourceKeys[keyIdx];
        if (key.endsWith("[]")) {
            String keyName = key.substring(0, key.length() - 2);
            if (data.isObject() && ((ObjectNode)data).has(keyName) && ((ObjectNode)data).get(keyName).isArray()) {
                ArrayNode arrayNode = (ArrayNode)((ObjectNode)data).get(keyName);
                for (JsonNode item : arrayNode) {
                    Common.moveValueRecursive(item, sourceKeys, destKeys, keyIdx + 1, excludeKeys);
                }
            }
        } else if (key.equals("*")) {
            if (data.isObject()) {
                ObjectNode objectNode = (ObjectNode)data;
                ArrayList<String> keysToMove = new ArrayList<String>();
                Iterator fieldNames = objectNode.fieldNames();
                while (fieldNames.hasNext()) {
                    String fieldName = (String)fieldNames.next();
                    if (fieldName.startsWith("_") || excludeKeys.contains(fieldName)) continue;
                    keysToMove.add(fieldName);
                }
                HashMap<String, JsonNode> valuesToMove = new HashMap<String, JsonNode>();
                for (String string : keysToMove) {
                    valuesToMove.put(string, objectNode.get(string));
                }
                for (Map.Entry entry : valuesToMove.entrySet()) {
                    String k = (String)entry.getKey();
                    JsonNode v = (JsonNode)entry.getValue();
                    ArrayList<String> newDestKeysList = new ArrayList<String>();
                    for (int i = keyIdx; i < destKeys.length; ++i) {
                        String dk = destKeys[i];
                        if (dk.equals("*")) {
                            newDestKeysList.add(k);
                            continue;
                        }
                        newDestKeysList.add(dk);
                    }
                    String[] newDestKeys = newDestKeysList.toArray(new String[0]);
                    Common.setValueByPath(objectNode, newDestKeys, v);
                }
                for (String string : keysToMove) {
                    objectNode.remove(string);
                }
            }
        } else if (data.isObject() && ((ObjectNode)data).has(key)) {
            JsonNode nextNode = ((ObjectNode)data).get(key);
            Common.moveValueRecursive(nextNode, sourceKeys, destKeys, keyIdx + 1, excludeKeys);
        }
    }

    public static class BuiltRequest {
        final String path;
        final String body;
        final Optional<HttpOptions> httpOptions;

        public BuiltRequest(String path, String body, Optional<HttpOptions> httpOptions) {
            this.path = path;
            this.body = body;
            this.httpOptions = httpOptions;
        }

        public String body() {
            return this.body;
        }

        public String path() {
            return this.path;
        }

        public Optional<HttpOptions> httpOptions() {
            return this.httpOptions;
        }
    }
}

