/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.genai.ResponseStream;
import com.google.genai.types.Candidate;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.Part;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

class ChatBase {
    protected final List<Content> comprehensiveHistory = new ArrayList<Content>();
    protected final List<Content> curatedHistory = new ArrayList<Content>();
    protected ResponseStream<GenerateContentResponse> currentResponseStream;
    protected List<Content> currentUserMessage;
    private static final Logger logger = Logger.getLogger(ChatBase.class.getName());

    ChatBase(List<Content> comprehensiveHistory, List<Content> curatedHistory) {
    }

    protected synchronized void recordHistory(List<Content> currentHistory, GenerateContentResponse response) {
        this.comprehensiveHistory.addAll(currentHistory);
        List<Content> validatedHistory = this.validateHistory(currentHistory);
        try {
            response.checkFinishReason();
            this.curatedHistory.addAll(validatedHistory);
        }
        catch (IllegalArgumentException e) {
            logger.warning("Response finished unexpectedly with reason: " + response.finishReason().toString() + ". Adding the response to comprehenisive history, but not to curated history.");
        }
    }

    protected boolean validateContent(Content content) {
        if (content.parts().isPresent()) {
            for (Part part : content.parts().get()) {
                if (!part.equals(Part.builder().build())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validateContents(List<Content> contents) {
        for (Content content : contents) {
            if (this.validateContent(content)) continue;
            return false;
        }
        return true;
    }

    protected List<Content> validateHistory(List<Content> history) {
        ArrayList<Content> validatedHistory = new ArrayList<Content>();
        ArrayList<Content> currentInput = new ArrayList<Content>();
        ArrayList<Content> currentOutput = new ArrayList<Content>();
        List<String> validRoles = Arrays.asList("user", "model");
        int i = 0;
        while (i < history.size()) {
            if (i == 0 && history.get(i).role().isPresent() && !history.get(i).role().get().equals("user") || this.curatedHistory.isEmpty() && !history.isEmpty() && history.get(0).role().isPresent() && !history.get(0).role().get().equals("user")) {
                throw new IllegalArgumentException("The first message in the history must be from the user.");
            }
            if (!validRoles.contains(history.get(i).role().get())) {
                throw new IllegalArgumentException("The role of the message must be either 'user' or 'model'.");
            }
            if (history.get(i).role().isPresent() && history.get(i).role().get().equals("user")) {
                if (this.validateContent(history.get(i))) {
                    currentInput.add(history.get(i));
                }
                ++i;
                continue;
            }
            boolean isValid = true;
            while (i < history.size() && history.get(i).role().isPresent() && history.get(i).role().get().equals("model")) {
                currentOutput.add(history.get(i));
                if (isValid && !this.validateContent(history.get(i))) {
                    isValid = false;
                }
                ++i;
            }
            if (!isValid) continue;
            validatedHistory.addAll(currentInput);
            validatedHistory.addAll(currentOutput);
            currentInput = new ArrayList();
            currentOutput = new ArrayList();
        }
        return validatedHistory;
    }

    public ImmutableList<Content> getHistory(boolean curated) {
        this.throwIfStreamNotConsumed();
        if (curated) {
            return ImmutableList.copyOf(this.curatedHistory);
        }
        return ImmutableList.copyOf(this.comprehensiveHistory);
    }

    private List<Content> aggregateStreamingResponse(List<GenerateContentResponse> responseChunks) {
        ArrayList<Content> aggregatedContents = new ArrayList<Content>();
        if (responseChunks == null || responseChunks.isEmpty()) {
            return aggregatedContents;
        }
        String aggregatedText = "";
        for (GenerateContentResponse responseChunk : responseChunks) {
            Candidate candidate;
            if (responseChunk == null || !(candidate = responseChunk.candidates().get().get(0)).content().isPresent()) continue;
            aggregatedContents.add(candidate.content().get());
        }
        return aggregatedContents;
    }

    protected void checkStreamResponseAndUpdateHistory() {
        if (this.currentResponseStream != null && this.currentUserMessage != null) {
            this.throwIfStreamNotConsumed();
            ArrayList<Content> streamingResponseContents = new ArrayList<Content>();
            streamingResponseContents.addAll(this.currentUserMessage);
            List<Content> aggregatedResponse = this.aggregateStreamingResponse(this.currentResponseStream.history);
            streamingResponseContents.addAll(aggregatedResponse);
            this.recordHistory(streamingResponseContents, (GenerateContentResponse)Iterables.getLast(this.currentResponseStream.history));
        }
        this.currentUserMessage = null;
        this.currentResponseStream = null;
    }

    protected void throwIfStreamNotConsumed() {
        if (this.currentResponseStream != null && this.currentUserMessage != null && !this.currentResponseStream.isConsumed()) {
            throw new IllegalStateException("Response stream is not consumed");
        }
    }

    protected List<Content> prepareSendMessageRequest(List<Content> newContents) {
        this.throwIfStreamNotConsumed();
        if (!this.validateContents(newContents)) {
            throw new IllegalArgumentException("The content of the message is invalid.");
        }
        ArrayList<Content> requestContents = new ArrayList<Content>();
        requestContents.addAll(this.curatedHistory);
        requestContents.addAll(newContents);
        return requestContents;
    }

    protected void updateHistoryNonStreaming(GenerateContentResponse modelResponse, List<Content> userInputContents) {
        ArrayList<Content> inputContents = new ArrayList<Content>();
        if (modelResponse.automaticFunctionCallingHistory().isPresent() && !modelResponse.automaticFunctionCallingHistory().get().isEmpty()) {
            inputContents.addAll(modelResponse.automaticFunctionCallingHistory().get().subList(this.curatedHistory.size(), modelResponse.automaticFunctionCallingHistory().get().size()));
        } else {
            inputContents.addAll(userInputContents);
        }
        ArrayList<Content> currentHistory = new ArrayList<Content>();
        Content modelResponseContent = modelResponse.candidates().get().get(0).content().get();
        currentHistory.addAll(inputContents);
        currentHistory.add(modelResponseContent);
        this.recordHistory(currentHistory, modelResponse);
    }
}

