/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.BasePager;
import com.google.genai.Common;
import com.google.genai.ExcludeFromGeneratedCoverageReport;
import com.google.genai.JsonSerializable;
import com.google.genai.Pager;
import com.google.genai.Transformers;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.CachedContent;
import com.google.genai.types.CreateCachedContentConfig;
import com.google.genai.types.CreateCachedContentParameters;
import com.google.genai.types.DeleteCachedContentConfig;
import com.google.genai.types.DeleteCachedContentParameters;
import com.google.genai.types.DeleteCachedContentResponse;
import com.google.genai.types.GetCachedContentConfig;
import com.google.genai.types.GetCachedContentParameters;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.HttpResponse;
import com.google.genai.types.ListCachedContentsConfig;
import com.google.genai.types.ListCachedContentsParameters;
import com.google.genai.types.ListCachedContentsResponse;
import com.google.genai.types.UpdateCachedContentConfig;
import com.google.genai.types.UpdateCachedContentParameters;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.Headers;
import okhttp3.ResponseBody;

public final class Caches {
    final ApiClient apiClient;

    public Caches(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode blobToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"data"}) != null) {
            Common.setValueByPath(toObject, new String[]{"data"}, Common.getValueByPath(fromObject, new String[]{"data"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode contentToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"parts"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"parts"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.partToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"parts"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"role"}) != null) {
            Common.setValueByPath(toObject, new String[]{"role"}, Common.getValueByPath(fromObject, new String[]{"role"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createCachedContentConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ArrayNode result;
        ObjectMapper objectMapper;
        ArrayNode keyArray;
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"ttl"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"ttl"}, Common.getValueByPath(fromObject, new String[]{"ttl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"contents"}) != null) {
            keyArray = (ArrayNode)Transformers.tContents(Common.getValueByPath(fromObject, new String[]{"contents"}));
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.contentToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"contents"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"systemInstruction"}, this.contentToMldev(JsonSerializable.toJsonNode(Transformers.tContent(Common.getValueByPath(fromObject, new String[]{"systemInstruction"}))), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"tools"}) != null) {
            keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"tools"});
            objectMapper = new ObjectMapper();
            result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolToMldev(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"toolConfig"}, this.toolConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"toolConfig"})), toObject));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"kmsKeyName"}))) {
            throw new IllegalArgumentException("kmsKeyName parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createCachedContentConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"ttl"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"ttl"}, Common.getValueByPath(fromObject, new String[]{"ttl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"displayName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"displayName"}, Common.getValueByPath(fromObject, new String[]{"displayName"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"contents"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"contents"}, Transformers.tContents(Common.getValueByPath(fromObject, new String[]{"contents"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"systemInstruction"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"systemInstruction"}, Transformers.tContent(Common.getValueByPath(fromObject, new String[]{"systemInstruction"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"tools"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"tools"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.toolToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(parentObject, new String[]{"tools"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"toolConfig"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"toolConfig"}, Common.getValueByPath(fromObject, new String[]{"toolConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"kmsKeyName"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"encryption_spec", "kmsKeyName"}, Common.getValueByPath(fromObject, new String[]{"kmsKeyName"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createCachedContentParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Transformers.tCachesModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.createCachedContentConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode createCachedContentParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"model"}) != null) {
            Common.setValueByPath(toObject, new String[]{"model"}, Transformers.tCachesModel(this.apiClient, Common.getValueByPath(fromObject, new String[]{"model"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.createCachedContentConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteCachedContentParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteCachedContentParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteCachedContentResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode deleteCachedContentResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode fileDataToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"displayName"}))) {
            throw new IllegalArgumentException("displayName parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileUri"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileUri"}, Common.getValueByPath(fromObject, new String[]{"fileUri"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mimeType"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mimeType"}, Common.getValueByPath(fromObject, new String[]{"mimeType"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"id"}) != null) {
            Common.setValueByPath(toObject, new String[]{"id"}, Common.getValueByPath(fromObject, new String[]{"id"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"args"}) != null) {
            Common.setValueByPath(toObject, new String[]{"args"}, Common.getValueByPath(fromObject, new String[]{"args"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"partialArgs"}))) {
            throw new IllegalArgumentException("partialArgs parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"willContinue"}))) {
            throw new IllegalArgumentException("willContinue parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionCallingConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}) != null) {
            Common.setValueByPath(toObject, new String[]{"allowedFunctionNames"}, Common.getValueByPath(fromObject, new String[]{"allowedFunctionNames"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"mode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mode"}, Common.getValueByPath(fromObject, new String[]{"mode"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"streamFunctionCallArguments"}))) {
            throw new IllegalArgumentException("streamFunctionCallArguments parameter is not supported in Gemini API.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode functionDeclarationToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"description"}) != null) {
            Common.setValueByPath(toObject, new String[]{"description"}, Common.getValueByPath(fromObject, new String[]{"description"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"name"}, Common.getValueByPath(fromObject, new String[]{"name"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parameters"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parameters"}, Common.getValueByPath(fromObject, new String[]{"parameters"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"parametersJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"parametersJsonSchema"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"response"}) != null) {
            Common.setValueByPath(toObject, new String[]{"response"}, Common.getValueByPath(fromObject, new String[]{"response"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}) != null) {
            Common.setValueByPath(toObject, new String[]{"responseJsonSchema"}, Common.getValueByPath(fromObject, new String[]{"responseJsonSchema"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"behavior"}))) {
            throw new IllegalArgumentException("behavior parameter is not supported in Vertex AI.");
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getCachedContentParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode getCachedContentParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleMapsToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"authConfig"}))) {
            throw new IllegalArgumentException("authConfig parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"enableWidget"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enableWidget"}, Common.getValueByPath(fromObject, new String[]{"enableWidget"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode googleSearchToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"excludeDomains"}))) {
            throw new IllegalArgumentException("excludeDomains parameter is not supported in Gemini API.");
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"blockingConfidence"}))) {
            throw new IllegalArgumentException("blockingConfidence parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}) != null) {
            Common.setValueByPath(toObject, new String[]{"timeRangeFilter"}, Common.getValueByPath(fromObject, new String[]{"timeRangeFilter"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"pageSize"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageSize"}, Common.getValueByPath(fromObject, new String[]{"pageSize"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"pageToken"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"_query", "pageToken"}, Common.getValueByPath(fromObject, new String[]{"pageToken"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsParametersToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.listCachedContentsConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsParametersToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.listCachedContentsConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsResponseFromMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"cachedContents"}) != null) {
            Common.setValueByPath(toObject, new String[]{"cachedContents"}, Common.getValueByPath(fromObject, new String[]{"cachedContents"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode listCachedContentsResponseFromVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"sdkHttpResponse"}, Common.getValueByPath(fromObject, new String[]{"sdkHttpResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"nextPageToken"}) != null) {
            Common.setValueByPath(toObject, new String[]{"nextPageToken"}, Common.getValueByPath(fromObject, new String[]{"nextPageToken"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"cachedContents"}) != null) {
            Common.setValueByPath(toObject, new String[]{"cachedContents"}, Common.getValueByPath(fromObject, new String[]{"cachedContents"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode partToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"mediaResolution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"mediaResolution"}, Common.getValueByPath(fromObject, new String[]{"mediaResolution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecutionResult"}, Common.getValueByPath(fromObject, new String[]{"codeExecutionResult"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"executableCode"}) != null) {
            Common.setValueByPath(toObject, new String[]{"executableCode"}, Common.getValueByPath(fromObject, new String[]{"executableCode"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileData"}, this.fileDataToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"fileData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCall"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCall"}, this.functionCallToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCall"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionResponse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionResponse"}, Common.getValueByPath(fromObject, new String[]{"functionResponse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"inlineData"}) != null) {
            Common.setValueByPath(toObject, new String[]{"inlineData"}, this.blobToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"inlineData"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"text"}) != null) {
            Common.setValueByPath(toObject, new String[]{"text"}, Common.getValueByPath(fromObject, new String[]{"text"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thought"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thought"}, Common.getValueByPath(fromObject, new String[]{"thought"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}) != null) {
            Common.setValueByPath(toObject, new String[]{"thoughtSignature"}, Common.getValueByPath(fromObject, new String[]{"thoughtSignature"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"videoMetadata"}) != null) {
            Common.setValueByPath(toObject, new String[]{"videoMetadata"}, Common.getValueByPath(fromObject, new String[]{"videoMetadata"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"retrievalConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrievalConfig"}, Common.getValueByPath(fromObject, new String[]{"retrievalConfig"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionCallingConfig"}, this.functionCallingConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"functionCallingConfig"})), toObject));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"retrieval"}))) {
            throw new IllegalArgumentException("retrieval parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"computerUse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"computerUse"}, Common.getValueByPath(fromObject, new String[]{"computerUse"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"fileSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"fileSearch"}, Common.getValueByPath(fromObject, new String[]{"fileSearch"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}))) {
            throw new IllegalArgumentException("enterpriseWebSearch parameter is not supported in Gemini API.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleMaps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleMaps"}, this.googleMapsToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleMaps"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, this.googleSearchToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"googleSearch"})), toObject));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, Common.getValueByPath(fromObject, new String[]{"urlContext"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode toolToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"retrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"retrieval"}, Common.getValueByPath(fromObject, new String[]{"retrieval"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"computerUse"}) != null) {
            Common.setValueByPath(toObject, new String[]{"computerUse"}, Common.getValueByPath(fromObject, new String[]{"computerUse"}));
        }
        if (!Common.isZero(Common.getValueByPath(fromObject, new String[]{"fileSearch"}))) {
            throw new IllegalArgumentException("fileSearch parameter is not supported in Vertex AI.");
        }
        if (Common.getValueByPath(fromObject, new String[]{"codeExecution"}) != null) {
            Common.setValueByPath(toObject, new String[]{"codeExecution"}, Common.getValueByPath(fromObject, new String[]{"codeExecution"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"enterpriseWebSearch"}, Common.getValueByPath(fromObject, new String[]{"enterpriseWebSearch"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"functionDeclarations"}) != null) {
            ArrayNode keyArray = (ArrayNode)Common.getValueByPath(fromObject, new String[]{"functionDeclarations"});
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode result = objectMapper.createArrayNode();
            for (JsonNode item : keyArray) {
                result.add((JsonNode)this.functionDeclarationToVertex(JsonSerializable.toJsonNode(item), toObject));
            }
            Common.setValueByPath(toObject, new String[]{"functionDeclarations"}, result);
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleMaps"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleMaps"}, Common.getValueByPath(fromObject, new String[]{"googleMaps"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearch"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearch"}, Common.getValueByPath(fromObject, new String[]{"googleSearch"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}) != null) {
            Common.setValueByPath(toObject, new String[]{"googleSearchRetrieval"}, Common.getValueByPath(fromObject, new String[]{"googleSearchRetrieval"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"urlContext"}) != null) {
            Common.setValueByPath(toObject, new String[]{"urlContext"}, Common.getValueByPath(fromObject, new String[]{"urlContext"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode updateCachedContentConfigToMldev(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"ttl"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"ttl"}, Common.getValueByPath(fromObject, new String[]{"ttl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode updateCachedContentConfigToVertex(JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"ttl"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"ttl"}, Common.getValueByPath(fromObject, new String[]{"ttl"}));
        }
        if (Common.getValueByPath(fromObject, new String[]{"expireTime"}) != null) {
            Common.setValueByPath(parentObject, new String[]{"expireTime"}, Common.getValueByPath(fromObject, new String[]{"expireTime"}));
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode updateCachedContentParametersToMldev(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.updateCachedContentConfigToMldev(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    @ExcludeFromGeneratedCoverageReport
    ObjectNode updateCachedContentParametersToVertex(ApiClient apiClient, JsonNode fromObject, ObjectNode parentObject) {
        ObjectNode toObject = JsonSerializable.objectMapper().createObjectNode();
        if (Common.getValueByPath(fromObject, new String[]{"name"}) != null) {
            Common.setValueByPath(toObject, new String[]{"_url", "name"}, Transformers.tCachedContentName(this.apiClient, Common.getValueByPath(fromObject, new String[]{"name"})));
        }
        if (Common.getValueByPath(fromObject, new String[]{"config"}) != null) {
            ObjectNode objectNode = this.updateCachedContentConfigToVertex(JsonSerializable.toJsonNode(Common.getValueByPath(fromObject, new String[]{"config"})), toObject);
        }
        return toObject;
    }

    Common.BuiltRequest buildRequestForCreate(String model, CreateCachedContentConfig config) {
        String path;
        ObjectNode body;
        CreateCachedContentParameters.Builder parameterBuilder = CreateCachedContentParameters.builder();
        if (!Common.isZero(model)) {
            parameterBuilder.model(model);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.createCachedContentParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("cachedContents", body.get("_url"));
        } else {
            body = this.createCachedContentParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("cachedContents", body.get("_url")) : "cachedContents";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    CachedContent processResponseForCreate(ApiResponse response, CreateCachedContentConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        return JsonSerializable.fromJsonNode(responseNode, CachedContent.class);
    }

    public CachedContent create(String model, CreateCachedContentConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForCreate(model, config);
        try (ApiResponse response = this.apiClient.request("post", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            CachedContent cachedContent = this.processResponseForCreate(response, config);
            return cachedContent;
        }
    }

    Common.BuiltRequest buildRequestForGet(String name, GetCachedContentConfig config) {
        String path;
        ObjectNode body;
        GetCachedContentParameters.Builder parameterBuilder = GetCachedContentParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.getCachedContentParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("{name}", body.get("_url"));
        } else {
            body = this.getCachedContentParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    CachedContent processResponseForGet(ApiResponse response, GetCachedContentConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        return JsonSerializable.fromJsonNode(responseNode, CachedContent.class);
    }

    public CachedContent get(String name, GetCachedContentConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForGet(name, config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            CachedContent cachedContent = this.processResponseForGet(response, config);
            return cachedContent;
        }
    }

    Common.BuiltRequest buildRequestForDelete(String name, DeleteCachedContentConfig config) {
        String path;
        ObjectNode body;
        DeleteCachedContentParameters.Builder parameterBuilder = DeleteCachedContentParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.deleteCachedContentParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("{name}", body.get("_url"));
        } else {
            body = this.deleteCachedContentParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    DeleteCachedContentResponse processResponseForDelete(ApiResponse response, DeleteCachedContentConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            responseNode = this.deleteCachedContentResponseFromVertex(responseNode, null);
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.deleteCachedContentResponseFromMldev(responseNode, null);
        }
        DeleteCachedContentResponse sdkResponse = JsonSerializable.fromJsonNode(responseNode, DeleteCachedContentResponse.class);
        Headers responseHeaders = response.getHeaders();
        if (responseHeaders == null) {
            return sdkResponse;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : responseHeaders.names()) {
            headers.put(headerName, responseHeaders.get(headerName));
        }
        return sdkResponse.toBuilder().sdkHttpResponse(HttpResponse.builder().headers(headers)).build();
    }

    public DeleteCachedContentResponse delete(String name, DeleteCachedContentConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForDelete(name, config);
        try (ApiResponse response = this.apiClient.request("delete", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            DeleteCachedContentResponse deleteCachedContentResponse = this.processResponseForDelete(response, config);
            return deleteCachedContentResponse;
        }
    }

    Common.BuiltRequest buildRequestForUpdate(String name, UpdateCachedContentConfig config) {
        String path;
        ObjectNode body;
        UpdateCachedContentParameters.Builder parameterBuilder = UpdateCachedContentParameters.builder();
        if (!Common.isZero(name)) {
            parameterBuilder.name(name);
        }
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.updateCachedContentParametersToVertex(this.apiClient, parameterNode, null);
            path = Common.formatMap("{name}", body.get("_url"));
        } else {
            body = this.updateCachedContentParametersToMldev(this.apiClient, parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("{name}", body.get("_url")) : "{name}";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    CachedContent processResponseForUpdate(ApiResponse response, UpdateCachedContentConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        return JsonSerializable.fromJsonNode(responseNode, CachedContent.class);
    }

    public CachedContent update(String name, UpdateCachedContentConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForUpdate(name, config);
        try (ApiResponse response = this.apiClient.request("patch", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            CachedContent cachedContent = this.processResponseForUpdate(response, config);
            return cachedContent;
        }
    }

    Common.BuiltRequest buildRequestForPrivateList(ListCachedContentsConfig config) {
        String path;
        ObjectNode body;
        ListCachedContentsParameters.Builder parameterBuilder = ListCachedContentsParameters.builder();
        if (!Common.isZero(config)) {
            parameterBuilder.config(config);
        }
        JsonNode parameterNode = JsonSerializable.toJsonNode(parameterBuilder.build());
        if (this.apiClient.vertexAI()) {
            body = this.listCachedContentsParametersToVertex(parameterNode, null);
            path = Common.formatMap("cachedContents", body.get("_url"));
        } else {
            body = this.listCachedContentsParametersToMldev(parameterNode, null);
            path = body.get("_url") != null ? Common.formatMap("cachedContents", body.get("_url")) : "cachedContents";
        }
        body.remove("_url");
        JsonNode queryParams = body.get("_query");
        if (queryParams != null) {
            body.remove("_query");
            path = String.format("%s?%s", path, Common.urlEncode((ObjectNode)queryParams));
        }
        Optional<HttpOptions> requestHttpOptions = Optional.empty();
        if (config != null) {
            requestHttpOptions = config.httpOptions();
        }
        return new Common.BuiltRequest(path, JsonSerializable.toJsonString(body), requestHttpOptions);
    }

    ListCachedContentsResponse processResponseForPrivateList(ApiResponse response, ListCachedContentsConfig config) {
        String responseString;
        ResponseBody responseBody = response.getBody();
        try {
            responseString = responseBody.string();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        JsonNode responseNode = JsonSerializable.stringToJsonNode(responseString);
        if (this.apiClient.vertexAI()) {
            responseNode = this.listCachedContentsResponseFromVertex(responseNode, null);
        }
        if (!this.apiClient.vertexAI()) {
            responseNode = this.listCachedContentsResponseFromMldev(responseNode, null);
        }
        ListCachedContentsResponse sdkResponse = JsonSerializable.fromJsonNode(responseNode, ListCachedContentsResponse.class);
        Headers responseHeaders = response.getHeaders();
        if (responseHeaders == null) {
            return sdkResponse;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : responseHeaders.names()) {
            headers.put(headerName, responseHeaders.get(headerName));
        }
        return sdkResponse.toBuilder().sdkHttpResponse(HttpResponse.builder().headers(headers)).build();
    }

    ListCachedContentsResponse privateList(ListCachedContentsConfig config) {
        Common.BuiltRequest builtRequest = this.buildRequestForPrivateList(config);
        try (ApiResponse response = this.apiClient.request("get", builtRequest.path(), builtRequest.body(), builtRequest.httpOptions());){
            ListCachedContentsResponse listCachedContentsResponse = this.processResponseForPrivateList(response, config);
            return listCachedContentsResponse;
        }
    }

    public Pager<CachedContent> list(ListCachedContentsConfig config) {
        if (config == null) {
            config = ListCachedContentsConfig.builder().build();
        }
        Function<JsonSerializable, Object> request = requestConfig -> {
            if (!(requestConfig instanceof ListCachedContentsConfig)) {
                throw new GenAiIOException("Internal error: Pager expected ListCachedContentsConfig but received " + requestConfig.getClass().getName());
            }
            return this.privateList((ListCachedContentsConfig)requestConfig);
        };
        return new Pager<CachedContent>(BasePager.PagedItem.CACHED_CONTENTS, request, (ObjectNode)JsonSerializable.toJsonNode(config), JsonSerializable.toJsonNode(this.privateList(config)));
    }
}

