/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.Common;
import com.google.genai.Tokens;
import com.google.genai.types.AuthToken;
import com.google.genai.types.CreateAuthTokenConfig;
import java.util.concurrent.CompletableFuture;

public final class AsyncTokens {
    Tokens tokens;
    ApiClient apiClient;

    public AsyncTokens(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.tokens = new Tokens(apiClient);
    }

    public CompletableFuture<AuthToken> create(CreateAuthTokenConfig config) {
        Common.BuiltRequest builtRequest = this.tokens.buildRequestForCreate(config);
        return this.apiClient.asyncRequest("post", builtRequest.path, builtRequest.body, builtRequest.httpOptions).thenApplyAsync(response -> {
            try (ApiResponse res = response;){
                AuthToken authToken = this.tokens.processResponseForCreate(res, config);
                return authToken;
            }
        });
    }
}

