/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_VertexRagStore;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.RagRetrievalConfig;
import com.google.genai.types.VertexRagStoreRagResource;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class VertexRagStore
extends JsonSerializable {
    @JsonProperty(value="ragCorpora")
    public abstract Optional<List<String>> ragCorpora();

    @JsonProperty(value="ragResources")
    public abstract Optional<List<VertexRagStoreRagResource>> ragResources();

    @JsonProperty(value="ragRetrievalConfig")
    public abstract Optional<RagRetrievalConfig> ragRetrievalConfig();

    @JsonProperty(value="similarityTopK")
    public abstract Optional<Integer> similarityTopK();

    @JsonProperty(value="storeContext")
    public abstract Optional<Boolean> storeContext();

    @JsonProperty(value="vectorDistanceThreshold")
    public abstract Optional<Double> vectorDistanceThreshold();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_VertexRagStore.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static VertexRagStore fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, VertexRagStore.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_VertexRagStore.Builder();
        }

        @JsonProperty(value="ragCorpora")
        public abstract Builder ragCorpora(List<String> var1);

        @CanIgnoreReturnValue
        public Builder ragCorpora(String ... ragCorpora) {
            return this.ragCorpora(Arrays.asList(ragCorpora));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder ragCorpora(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRagCorpora() {
            return this.ragCorpora(Optional.empty());
        }

        @JsonProperty(value="ragResources")
        public abstract Builder ragResources(List<VertexRagStoreRagResource> var1);

        @CanIgnoreReturnValue
        public Builder ragResources(VertexRagStoreRagResource ... ragResources) {
            return this.ragResources(Arrays.asList(ragResources));
        }

        @CanIgnoreReturnValue
        public Builder ragResources(VertexRagStoreRagResource.Builder ... ragResourcesBuilders) {
            return this.ragResources((List)Arrays.asList(ragResourcesBuilders).stream().map(VertexRagStoreRagResource.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder ragResources(Optional<List<VertexRagStoreRagResource>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRagResources() {
            return this.ragResources(Optional.empty());
        }

        @JsonProperty(value="ragRetrievalConfig")
        public abstract Builder ragRetrievalConfig(RagRetrievalConfig var1);

        @CanIgnoreReturnValue
        public Builder ragRetrievalConfig(RagRetrievalConfig.Builder ragRetrievalConfigBuilder) {
            return this.ragRetrievalConfig(ragRetrievalConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder ragRetrievalConfig(Optional<RagRetrievalConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRagRetrievalConfig() {
            return this.ragRetrievalConfig(Optional.empty());
        }

        @JsonProperty(value="similarityTopK")
        public abstract Builder similarityTopK(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder similarityTopK(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSimilarityTopK() {
            return this.similarityTopK(Optional.empty());
        }

        @JsonProperty(value="storeContext")
        public abstract Builder storeContext(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder storeContext(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStoreContext() {
            return this.storeContext(Optional.empty());
        }

        @JsonProperty(value="vectorDistanceThreshold")
        public abstract Builder vectorDistanceThreshold(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder vectorDistanceThreshold(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVectorDistanceThreshold() {
            return this.vectorDistanceThreshold(Optional.empty());
        }

        public abstract VertexRagStore build();
    }
}

