/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_VertexAISearch;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.VertexAISearchDataStoreSpec;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class VertexAISearch
extends JsonSerializable {
    @JsonProperty(value="dataStoreSpecs")
    public abstract Optional<List<VertexAISearchDataStoreSpec>> dataStoreSpecs();

    @JsonProperty(value="datastore")
    public abstract Optional<String> datastore();

    @JsonProperty(value="engine")
    public abstract Optional<String> engine();

    @JsonProperty(value="filter")
    public abstract Optional<String> filter();

    @JsonProperty(value="maxResults")
    public abstract Optional<Integer> maxResults();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_VertexAISearch.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static VertexAISearch fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, VertexAISearch.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_VertexAISearch.Builder();
        }

        @JsonProperty(value="dataStoreSpecs")
        public abstract Builder dataStoreSpecs(List<VertexAISearchDataStoreSpec> var1);

        @CanIgnoreReturnValue
        public Builder dataStoreSpecs(VertexAISearchDataStoreSpec ... dataStoreSpecs) {
            return this.dataStoreSpecs(Arrays.asList(dataStoreSpecs));
        }

        @CanIgnoreReturnValue
        public Builder dataStoreSpecs(VertexAISearchDataStoreSpec.Builder ... dataStoreSpecsBuilders) {
            return this.dataStoreSpecs((List)Arrays.asList(dataStoreSpecsBuilders).stream().map(VertexAISearchDataStoreSpec.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder dataStoreSpecs(Optional<List<VertexAISearchDataStoreSpec>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDataStoreSpecs() {
            return this.dataStoreSpecs(Optional.empty());
        }

        @JsonProperty(value="datastore")
        public abstract Builder datastore(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder datastore(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDatastore() {
            return this.datastore(Optional.empty());
        }

        @JsonProperty(value="engine")
        public abstract Builder engine(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder engine(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEngine() {
            return this.engine(Optional.empty());
        }

        @JsonProperty(value="filter")
        public abstract Builder filter(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder filter(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFilter() {
            return this.filter(Optional.empty());
        }

        @JsonProperty(value="maxResults")
        public abstract Builder maxResults(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxResults(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxResults() {
            return this.maxResults(Optional.empty());
        }

        public abstract VertexAISearch build();
    }
}

