/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_VeoHyperParameters;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.TuningTask;
import java.util.Optional;

@InternalApi
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class VeoHyperParameters
extends JsonSerializable {
    @JsonProperty(value="epochCount")
    public abstract Optional<Long> epochCount();

    @JsonProperty(value="learningRateMultiplier")
    public abstract Optional<Double> learningRateMultiplier();

    @JsonProperty(value="tuningTask")
    public abstract Optional<TuningTask> tuningTask();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_VeoHyperParameters.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static VeoHyperParameters fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, VeoHyperParameters.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_VeoHyperParameters.Builder();
        }

        @JsonProperty(value="epochCount")
        public abstract Builder epochCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder epochCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEpochCount() {
            return this.epochCount(Optional.empty());
        }

        @JsonProperty(value="learningRateMultiplier")
        public abstract Builder learningRateMultiplier(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder learningRateMultiplier(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLearningRateMultiplier() {
            return this.learningRateMultiplier(Optional.empty());
        }

        @JsonProperty(value="tuningTask")
        public abstract Builder tuningTask(TuningTask var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tuningTask(Optional<TuningTask> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTuningTask() {
            return this.tuningTask(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder tuningTask(TuningTask.Known knownType) {
            return this.tuningTask(new TuningTask(knownType));
        }

        @CanIgnoreReturnValue
        public Builder tuningTask(String tuningTask) {
            return this.tuningTask(new TuningTask(tuningTask));
        }

        public abstract VeoHyperParameters build();
    }
}

