/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_UpscaleImageConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.PersonGeneration;
import com.google.genai.types.SafetyFilterLevel;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class UpscaleImageConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="outputGcsUri")
    public abstract Optional<String> outputGcsUri();

    @JsonProperty(value="safetyFilterLevel")
    public abstract Optional<SafetyFilterLevel> safetyFilterLevel();

    @JsonProperty(value="personGeneration")
    public abstract Optional<PersonGeneration> personGeneration();

    @JsonProperty(value="includeRaiReason")
    public abstract Optional<Boolean> includeRaiReason();

    @JsonProperty(value="outputMimeType")
    public abstract Optional<String> outputMimeType();

    @JsonProperty(value="outputCompressionQuality")
    public abstract Optional<Integer> outputCompressionQuality();

    @JsonProperty(value="enhanceInputImage")
    public abstract Optional<Boolean> enhanceInputImage();

    @JsonProperty(value="imagePreservationFactor")
    public abstract Optional<Float> imagePreservationFactor();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_UpscaleImageConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static UpscaleImageConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, UpscaleImageConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_UpscaleImageConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="outputGcsUri")
        public abstract Builder outputGcsUri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputGcsUri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputGcsUri() {
            return this.outputGcsUri(Optional.empty());
        }

        @JsonProperty(value="safetyFilterLevel")
        public abstract Builder safetyFilterLevel(SafetyFilterLevel var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder safetyFilterLevel(Optional<SafetyFilterLevel> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSafetyFilterLevel() {
            return this.safetyFilterLevel(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder safetyFilterLevel(SafetyFilterLevel.Known knownType) {
            return this.safetyFilterLevel(new SafetyFilterLevel(knownType));
        }

        @CanIgnoreReturnValue
        public Builder safetyFilterLevel(String safetyFilterLevel) {
            return this.safetyFilterLevel(new SafetyFilterLevel(safetyFilterLevel));
        }

        @JsonProperty(value="personGeneration")
        public abstract Builder personGeneration(PersonGeneration var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder personGeneration(Optional<PersonGeneration> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPersonGeneration() {
            return this.personGeneration(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder personGeneration(PersonGeneration.Known knownType) {
            return this.personGeneration(new PersonGeneration(knownType));
        }

        @CanIgnoreReturnValue
        public Builder personGeneration(String personGeneration) {
            return this.personGeneration(new PersonGeneration(personGeneration));
        }

        @JsonProperty(value="includeRaiReason")
        public abstract Builder includeRaiReason(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder includeRaiReason(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearIncludeRaiReason() {
            return this.includeRaiReason(Optional.empty());
        }

        @JsonProperty(value="outputMimeType")
        public abstract Builder outputMimeType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputMimeType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputMimeType() {
            return this.outputMimeType(Optional.empty());
        }

        @JsonProperty(value="outputCompressionQuality")
        public abstract Builder outputCompressionQuality(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputCompressionQuality(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputCompressionQuality() {
            return this.outputCompressionQuality(Optional.empty());
        }

        @JsonProperty(value="enhanceInputImage")
        public abstract Builder enhanceInputImage(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder enhanceInputImage(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEnhanceInputImage() {
            return this.enhanceInputImage(Optional.empty());
        }

        @JsonProperty(value="imagePreservationFactor")
        public abstract Builder imagePreservationFactor(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder imagePreservationFactor(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearImagePreservationFactor() {
            return this.imagePreservationFactor(Optional.empty());
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder labels(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLabels() {
            return this.labels(Optional.empty());
        }

        public abstract UpscaleImageConfig build();
    }
}

