/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_SegmentImageConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.SegmentMode;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SegmentImageConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="mode")
    public abstract Optional<SegmentMode> mode();

    @JsonProperty(value="maxPredictions")
    public abstract Optional<Integer> maxPredictions();

    @JsonProperty(value="confidenceThreshold")
    public abstract Optional<Float> confidenceThreshold();

    @JsonProperty(value="maskDilation")
    public abstract Optional<Float> maskDilation();

    @JsonProperty(value="binaryColorThreshold")
    public abstract Optional<Float> binaryColorThreshold();

    @JsonProperty(value="labels")
    public abstract Optional<Map<String, String>> labels();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_SegmentImageConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static SegmentImageConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, SegmentImageConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_SegmentImageConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="mode")
        public abstract Builder mode(SegmentMode var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mode(Optional<SegmentMode> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMode() {
            return this.mode(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder mode(SegmentMode.Known knownType) {
            return this.mode(new SegmentMode(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mode(String mode) {
            return this.mode(new SegmentMode(mode));
        }

        @JsonProperty(value="maxPredictions")
        public abstract Builder maxPredictions(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxPredictions(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxPredictions() {
            return this.maxPredictions(Optional.empty());
        }

        @JsonProperty(value="confidenceThreshold")
        public abstract Builder confidenceThreshold(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder confidenceThreshold(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearConfidenceThreshold() {
            return this.confidenceThreshold(Optional.empty());
        }

        @JsonProperty(value="maskDilation")
        public abstract Builder maskDilation(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maskDilation(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaskDilation() {
            return this.maskDilation(Optional.empty());
        }

        @JsonProperty(value="binaryColorThreshold")
        public abstract Builder binaryColorThreshold(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder binaryColorThreshold(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBinaryColorThreshold() {
            return this.binaryColorThreshold(Optional.empty());
        }

        @JsonProperty(value="labels")
        public abstract Builder labels(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder labels(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLabels() {
            return this.labels(Optional.empty());
        }

        public abstract SegmentImageConfig build();
    }
}

