/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_SafetyRating;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HarmBlockThreshold;
import com.google.genai.types.HarmCategory;
import com.google.genai.types.HarmProbability;
import com.google.genai.types.HarmSeverity;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SafetyRating
extends JsonSerializable {
    @JsonProperty(value="blocked")
    public abstract Optional<Boolean> blocked();

    @JsonProperty(value="category")
    public abstract Optional<HarmCategory> category();

    @JsonProperty(value="overwrittenThreshold")
    public abstract Optional<HarmBlockThreshold> overwrittenThreshold();

    @JsonProperty(value="probability")
    public abstract Optional<HarmProbability> probability();

    @JsonProperty(value="probabilityScore")
    public abstract Optional<Float> probabilityScore();

    @JsonProperty(value="severity")
    public abstract Optional<HarmSeverity> severity();

    @JsonProperty(value="severityScore")
    public abstract Optional<Float> severityScore();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_SafetyRating.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static SafetyRating fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, SafetyRating.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_SafetyRating.Builder();
        }

        @JsonProperty(value="blocked")
        public abstract Builder blocked(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder blocked(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBlocked() {
            return this.blocked(Optional.empty());
        }

        @JsonProperty(value="category")
        public abstract Builder category(HarmCategory var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder category(Optional<HarmCategory> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCategory() {
            return this.category(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder category(HarmCategory.Known knownType) {
            return this.category(new HarmCategory(knownType));
        }

        @CanIgnoreReturnValue
        public Builder category(String category) {
            return this.category(new HarmCategory(category));
        }

        @JsonProperty(value="overwrittenThreshold")
        public abstract Builder overwrittenThreshold(HarmBlockThreshold var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder overwrittenThreshold(Optional<HarmBlockThreshold> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOverwrittenThreshold() {
            return this.overwrittenThreshold(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder overwrittenThreshold(HarmBlockThreshold.Known knownType) {
            return this.overwrittenThreshold(new HarmBlockThreshold(knownType));
        }

        @CanIgnoreReturnValue
        public Builder overwrittenThreshold(String overwrittenThreshold) {
            return this.overwrittenThreshold(new HarmBlockThreshold(overwrittenThreshold));
        }

        @JsonProperty(value="probability")
        public abstract Builder probability(HarmProbability var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder probability(Optional<HarmProbability> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearProbability() {
            return this.probability(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder probability(HarmProbability.Known knownType) {
            return this.probability(new HarmProbability(knownType));
        }

        @CanIgnoreReturnValue
        public Builder probability(String probability) {
            return this.probability(new HarmProbability(probability));
        }

        @JsonProperty(value="probabilityScore")
        public abstract Builder probabilityScore(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder probabilityScore(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearProbabilityScore() {
            return this.probabilityScore(Optional.empty());
        }

        @JsonProperty(value="severity")
        public abstract Builder severity(HarmSeverity var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder severity(Optional<HarmSeverity> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSeverity() {
            return this.severity(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder severity(HarmSeverity.Known knownType) {
            return this.severity(new HarmSeverity(knownType));
        }

        @CanIgnoreReturnValue
        public Builder severity(String severity) {
            return this.severity(new HarmSeverity(severity));
        }

        @JsonProperty(value="severityScore")
        public abstract Builder severityScore(Float var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder severityScore(Optional<Float> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSeverityScore() {
            return this.severityScore(Optional.empty());
        }

        public abstract SafetyRating build();
    }
}

