/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_ProxyOptions;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.ProxyType;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ProxyOptions
extends JsonSerializable {
    @JsonProperty(value="type")
    public abstract Optional<ProxyType> type();

    @JsonProperty(value="host")
    public abstract Optional<String> host();

    @JsonProperty(value="port")
    public abstract Optional<Integer> port();

    @JsonProperty(value="username")
    public abstract Optional<String> username();

    @JsonProperty(value="password")
    public abstract Optional<String> password();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_ProxyOptions.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static ProxyOptions fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, ProxyOptions.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_ProxyOptions.Builder();
        }

        @JsonProperty(value="type")
        public abstract Builder type(ProxyType var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder type(Optional<ProxyType> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearType() {
            return this.type(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder type(ProxyType.Known knownType) {
            return this.type(new ProxyType(knownType));
        }

        @CanIgnoreReturnValue
        public Builder type(String type) {
            return this.type(new ProxyType(type));
        }

        @JsonProperty(value="host")
        public abstract Builder host(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder host(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHost() {
            return this.host(Optional.empty());
        }

        @JsonProperty(value="port")
        public abstract Builder port(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder port(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPort() {
            return this.port(Optional.empty());
        }

        @JsonProperty(value="username")
        public abstract Builder username(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder username(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUsername() {
            return this.username(Optional.empty());
        }

        @JsonProperty(value="password")
        public abstract Builder password(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder password(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPassword() {
            return this.password(Optional.empty());
        }

        public abstract ProxyOptions build();
    }
}

