/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_PreferenceOptimizationDataStats;
import com.google.genai.types.DatasetDistribution;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GeminiPreferenceExample;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class PreferenceOptimizationDataStats
extends JsonSerializable {
    @JsonProperty(value="scoreVariancePerExampleDistribution")
    public abstract Optional<DatasetDistribution> scoreVariancePerExampleDistribution();

    @JsonProperty(value="scoresDistribution")
    public abstract Optional<DatasetDistribution> scoresDistribution();

    @JsonProperty(value="totalBillableTokenCount")
    public abstract Optional<Long> totalBillableTokenCount();

    @JsonProperty(value="tuningDatasetExampleCount")
    public abstract Optional<Long> tuningDatasetExampleCount();

    @JsonProperty(value="tuningStepCount")
    public abstract Optional<Long> tuningStepCount();

    @JsonProperty(value="userDatasetExamples")
    public abstract Optional<List<GeminiPreferenceExample>> userDatasetExamples();

    @JsonProperty(value="userInputTokenDistribution")
    public abstract Optional<DatasetDistribution> userInputTokenDistribution();

    @JsonProperty(value="userOutputTokenDistribution")
    public abstract Optional<DatasetDistribution> userOutputTokenDistribution();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_PreferenceOptimizationDataStats.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static PreferenceOptimizationDataStats fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, PreferenceOptimizationDataStats.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_PreferenceOptimizationDataStats.Builder();
        }

        @JsonProperty(value="scoreVariancePerExampleDistribution")
        public abstract Builder scoreVariancePerExampleDistribution(DatasetDistribution var1);

        @CanIgnoreReturnValue
        public Builder scoreVariancePerExampleDistribution(DatasetDistribution.Builder scoreVariancePerExampleDistributionBuilder) {
            return this.scoreVariancePerExampleDistribution(scoreVariancePerExampleDistributionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder scoreVariancePerExampleDistribution(Optional<DatasetDistribution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearScoreVariancePerExampleDistribution() {
            return this.scoreVariancePerExampleDistribution(Optional.empty());
        }

        @JsonProperty(value="scoresDistribution")
        public abstract Builder scoresDistribution(DatasetDistribution var1);

        @CanIgnoreReturnValue
        public Builder scoresDistribution(DatasetDistribution.Builder scoresDistributionBuilder) {
            return this.scoresDistribution(scoresDistributionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder scoresDistribution(Optional<DatasetDistribution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearScoresDistribution() {
            return this.scoresDistribution(Optional.empty());
        }

        @JsonProperty(value="totalBillableTokenCount")
        public abstract Builder totalBillableTokenCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder totalBillableTokenCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTotalBillableTokenCount() {
            return this.totalBillableTokenCount(Optional.empty());
        }

        @JsonProperty(value="tuningDatasetExampleCount")
        public abstract Builder tuningDatasetExampleCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tuningDatasetExampleCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTuningDatasetExampleCount() {
            return this.tuningDatasetExampleCount(Optional.empty());
        }

        @JsonProperty(value="tuningStepCount")
        public abstract Builder tuningStepCount(Long var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder tuningStepCount(Optional<Long> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTuningStepCount() {
            return this.tuningStepCount(Optional.empty());
        }

        @JsonProperty(value="userDatasetExamples")
        public abstract Builder userDatasetExamples(List<GeminiPreferenceExample> var1);

        @CanIgnoreReturnValue
        public Builder userDatasetExamples(GeminiPreferenceExample ... userDatasetExamples) {
            return this.userDatasetExamples(Arrays.asList(userDatasetExamples));
        }

        @CanIgnoreReturnValue
        public Builder userDatasetExamples(GeminiPreferenceExample.Builder ... userDatasetExamplesBuilders) {
            return this.userDatasetExamples((List)Arrays.asList(userDatasetExamplesBuilders).stream().map(GeminiPreferenceExample.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder userDatasetExamples(Optional<List<GeminiPreferenceExample>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUserDatasetExamples() {
            return this.userDatasetExamples(Optional.empty());
        }

        @JsonProperty(value="userInputTokenDistribution")
        public abstract Builder userInputTokenDistribution(DatasetDistribution var1);

        @CanIgnoreReturnValue
        public Builder userInputTokenDistribution(DatasetDistribution.Builder userInputTokenDistributionBuilder) {
            return this.userInputTokenDistribution(userInputTokenDistributionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder userInputTokenDistribution(Optional<DatasetDistribution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUserInputTokenDistribution() {
            return this.userInputTokenDistribution(Optional.empty());
        }

        @JsonProperty(value="userOutputTokenDistribution")
        public abstract Builder userOutputTokenDistribution(DatasetDistribution var1);

        @CanIgnoreReturnValue
        public Builder userOutputTokenDistribution(DatasetDistribution.Builder userOutputTokenDistributionBuilder) {
            return this.userOutputTokenDistribution(userOutputTokenDistributionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder userOutputTokenDistribution(Optional<DatasetDistribution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUserOutputTokenDistribution() {
            return this.userOutputTokenDistribution(Optional.empty());
        }

        public abstract PreferenceOptimizationDataStats build();
    }
}

