/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Part;
import com.google.genai.types.Blob;
import com.google.genai.types.CodeExecutionResult;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.ExecutableCode;
import com.google.genai.types.FileData;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.FunctionResponsePart;
import com.google.genai.types.PartMediaResolution;
import com.google.genai.types.VideoMetadata;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Part
extends JsonSerializable {
    @JsonProperty(value="mediaResolution")
    public abstract Optional<PartMediaResolution> mediaResolution();

    @JsonProperty(value="codeExecutionResult")
    public abstract Optional<CodeExecutionResult> codeExecutionResult();

    @JsonProperty(value="executableCode")
    public abstract Optional<ExecutableCode> executableCode();

    @JsonProperty(value="fileData")
    public abstract Optional<FileData> fileData();

    @JsonProperty(value="functionCall")
    public abstract Optional<FunctionCall> functionCall();

    @JsonProperty(value="functionResponse")
    public abstract Optional<FunctionResponse> functionResponse();

    @JsonProperty(value="inlineData")
    public abstract Optional<Blob> inlineData();

    @JsonProperty(value="text")
    public abstract Optional<String> text();

    @JsonProperty(value="thought")
    public abstract Optional<Boolean> thought();

    @JsonProperty(value="thoughtSignature")
    public abstract Optional<byte[]> thoughtSignature();

    @JsonProperty(value="videoMetadata")
    public abstract Optional<VideoMetadata> videoMetadata();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Part.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Part fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Part.class);
    }

    public static Part fromText(String text) {
        return Part.builder().text(text).build();
    }

    public static Part fromUri(String fileUri, String mimeType) {
        return Part.builder().fileData(FileData.builder().fileUri(fileUri).mimeType(mimeType).build()).build();
    }

    public static Part fromBytes(byte[] bytes, String mimeType) {
        return Part.builder().inlineData(Blob.builder().data(bytes).mimeType(mimeType).build()).build();
    }

    public static Part fromFunctionCall(String name, Map<String, Object> args) {
        return Part.builder().functionCall(FunctionCall.builder().name(name).args(args).build()).build();
    }

    public static Part fromFunctionResponse(String name, Map<String, Object> response, FunctionResponsePart ... functionResponseParts) {
        return Part.builder().functionResponse(FunctionResponse.builder().name(name).response(response).parts(functionResponseParts)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Part.Builder();
        }

        @JsonProperty(value="mediaResolution")
        public abstract Builder mediaResolution(PartMediaResolution var1);

        @CanIgnoreReturnValue
        public Builder mediaResolution(PartMediaResolution.Builder mediaResolutionBuilder) {
            return this.mediaResolution(mediaResolutionBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mediaResolution(Optional<PartMediaResolution> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMediaResolution() {
            return this.mediaResolution(Optional.empty());
        }

        @JsonProperty(value="codeExecutionResult")
        public abstract Builder codeExecutionResult(CodeExecutionResult var1);

        @CanIgnoreReturnValue
        public Builder codeExecutionResult(CodeExecutionResult.Builder codeExecutionResultBuilder) {
            return this.codeExecutionResult(codeExecutionResultBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder codeExecutionResult(Optional<CodeExecutionResult> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCodeExecutionResult() {
            return this.codeExecutionResult(Optional.empty());
        }

        @JsonProperty(value="executableCode")
        public abstract Builder executableCode(ExecutableCode var1);

        @CanIgnoreReturnValue
        public Builder executableCode(ExecutableCode.Builder executableCodeBuilder) {
            return this.executableCode(executableCodeBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder executableCode(Optional<ExecutableCode> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExecutableCode() {
            return this.executableCode(Optional.empty());
        }

        @JsonProperty(value="fileData")
        public abstract Builder fileData(FileData var1);

        @CanIgnoreReturnValue
        public Builder fileData(FileData.Builder fileDataBuilder) {
            return this.fileData(fileDataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder fileData(Optional<FileData> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFileData() {
            return this.fileData(Optional.empty());
        }

        @JsonProperty(value="functionCall")
        public abstract Builder functionCall(FunctionCall var1);

        @CanIgnoreReturnValue
        public Builder functionCall(FunctionCall.Builder functionCallBuilder) {
            return this.functionCall(functionCallBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder functionCall(Optional<FunctionCall> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFunctionCall() {
            return this.functionCall(Optional.empty());
        }

        @JsonProperty(value="functionResponse")
        public abstract Builder functionResponse(FunctionResponse var1);

        @CanIgnoreReturnValue
        public Builder functionResponse(FunctionResponse.Builder functionResponseBuilder) {
            return this.functionResponse(functionResponseBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder functionResponse(Optional<FunctionResponse> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFunctionResponse() {
            return this.functionResponse(Optional.empty());
        }

        @JsonProperty(value="inlineData")
        public abstract Builder inlineData(Blob var1);

        @CanIgnoreReturnValue
        public Builder inlineData(Blob.Builder inlineDataBuilder) {
            return this.inlineData(inlineDataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder inlineData(Optional<Blob> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearInlineData() {
            return this.inlineData(Optional.empty());
        }

        @JsonProperty(value="text")
        public abstract Builder text(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder text(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearText() {
            return this.text(Optional.empty());
        }

        @JsonProperty(value="thought")
        public abstract Builder thought(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder thought(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearThought() {
            return this.thought(Optional.empty());
        }

        @JsonProperty(value="thoughtSignature")
        public abstract Builder thoughtSignature(byte[] var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder thoughtSignature(Optional<byte[]> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearThoughtSignature() {
            return this.thoughtSignature(Optional.empty());
        }

        @JsonProperty(value="videoMetadata")
        public abstract Builder videoMetadata(VideoMetadata var1);

        @CanIgnoreReturnValue
        public Builder videoMetadata(VideoMetadata.Builder videoMetadataBuilder) {
            return this.videoMetadata(videoMetadataBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder videoMetadata(Optional<VideoMetadata> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVideoMetadata() {
            return this.videoMetadata(Optional.empty());
        }

        public abstract Part build();
    }
}

