/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.ActivityEnd;
import com.google.genai.types.ActivityStart;
import com.google.genai.types.AutoValue_LiveClientRealtimeInput;
import com.google.genai.types.Blob;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveClientRealtimeInput
extends JsonSerializable {
    @JsonProperty(value="mediaChunks")
    public abstract Optional<List<Blob>> mediaChunks();

    @JsonProperty(value="audio")
    public abstract Optional<Blob> audio();

    @JsonProperty(value="audioStreamEnd")
    public abstract Optional<Boolean> audioStreamEnd();

    @JsonProperty(value="video")
    public abstract Optional<Blob> video();

    @JsonProperty(value="text")
    public abstract Optional<String> text();

    @JsonProperty(value="activityStart")
    public abstract Optional<ActivityStart> activityStart();

    @JsonProperty(value="activityEnd")
    public abstract Optional<ActivityEnd> activityEnd();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_LiveClientRealtimeInput.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static LiveClientRealtimeInput fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, LiveClientRealtimeInput.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_LiveClientRealtimeInput.Builder();
        }

        @JsonProperty(value="mediaChunks")
        public abstract Builder mediaChunks(List<Blob> var1);

        @CanIgnoreReturnValue
        public Builder mediaChunks(Blob ... mediaChunks) {
            return this.mediaChunks(Arrays.asList(mediaChunks));
        }

        @CanIgnoreReturnValue
        public Builder mediaChunks(Blob.Builder ... mediaChunksBuilders) {
            return this.mediaChunks((List)Arrays.asList(mediaChunksBuilders).stream().map(Blob.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mediaChunks(Optional<List<Blob>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMediaChunks() {
            return this.mediaChunks(Optional.empty());
        }

        @JsonProperty(value="audio")
        public abstract Builder audio(Blob var1);

        @CanIgnoreReturnValue
        public Builder audio(Blob.Builder audioBuilder) {
            return this.audio(audioBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder audio(Optional<Blob> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAudio() {
            return this.audio(Optional.empty());
        }

        @JsonProperty(value="audioStreamEnd")
        public abstract Builder audioStreamEnd(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder audioStreamEnd(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAudioStreamEnd() {
            return this.audioStreamEnd(Optional.empty());
        }

        @JsonProperty(value="video")
        public abstract Builder video(Blob var1);

        @CanIgnoreReturnValue
        public Builder video(Blob.Builder videoBuilder) {
            return this.video(videoBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder video(Optional<Blob> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVideo() {
            return this.video(Optional.empty());
        }

        @JsonProperty(value="text")
        public abstract Builder text(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder text(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearText() {
            return this.text(Optional.empty());
        }

        @JsonProperty(value="activityStart")
        public abstract Builder activityStart(ActivityStart var1);

        @CanIgnoreReturnValue
        public Builder activityStart(ActivityStart.Builder activityStartBuilder) {
            return this.activityStart(activityStartBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder activityStart(Optional<ActivityStart> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearActivityStart() {
            return this.activityStart(Optional.empty());
        }

        @JsonProperty(value="activityEnd")
        public abstract Builder activityEnd(ActivityEnd var1);

        @CanIgnoreReturnValue
        public Builder activityEnd(ActivityEnd.Builder activityEndBuilder) {
            return this.activityEnd(activityEndBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder activityEnd(Optional<ActivityEnd> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearActivityEnd() {
            return this.activityEnd(Optional.empty());
        }

        public abstract LiveClientRealtimeInput build();
    }
}

