/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_ImageConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ImageConfig
extends JsonSerializable {
    @JsonProperty(value="aspectRatio")
    public abstract Optional<String> aspectRatio();

    @JsonProperty(value="imageSize")
    public abstract Optional<String> imageSize();

    @JsonProperty(value="personGeneration")
    public abstract Optional<String> personGeneration();

    @JsonProperty(value="outputMimeType")
    public abstract Optional<String> outputMimeType();

    @JsonProperty(value="outputCompressionQuality")
    public abstract Optional<Integer> outputCompressionQuality();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_ImageConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static ImageConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, ImageConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_ImageConfig.Builder();
        }

        @JsonProperty(value="aspectRatio")
        public abstract Builder aspectRatio(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder aspectRatio(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAspectRatio() {
            return this.aspectRatio(Optional.empty());
        }

        @JsonProperty(value="imageSize")
        public abstract Builder imageSize(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder imageSize(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearImageSize() {
            return this.imageSize(Optional.empty());
        }

        @JsonProperty(value="personGeneration")
        public abstract Builder personGeneration(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder personGeneration(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPersonGeneration() {
            return this.personGeneration(Optional.empty());
        }

        @JsonProperty(value="outputMimeType")
        public abstract Builder outputMimeType(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputMimeType(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputMimeType() {
            return this.outputMimeType(Optional.empty());
        }

        @JsonProperty(value="outputCompressionQuality")
        public abstract Builder outputCompressionQuality(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputCompressionQuality(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputCompressionQuality() {
            return this.outputCompressionQuality(Optional.empty());
        }

        public abstract ImageConfig build();
    }
}

