/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_HttpRetryOptions;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class HttpRetryOptions
extends JsonSerializable {
    @JsonProperty(value="attempts")
    public abstract Optional<Integer> attempts();

    @JsonProperty(value="initialDelay")
    public abstract Optional<Double> initialDelay();

    @JsonProperty(value="maxDelay")
    public abstract Optional<Double> maxDelay();

    @JsonProperty(value="expBase")
    public abstract Optional<Double> expBase();

    @JsonProperty(value="jitter")
    public abstract Optional<Double> jitter();

    @JsonProperty(value="httpStatusCodes")
    public abstract Optional<List<Integer>> httpStatusCodes();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_HttpRetryOptions.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static HttpRetryOptions fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, HttpRetryOptions.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_HttpRetryOptions.Builder();
        }

        @JsonProperty(value="attempts")
        public abstract Builder attempts(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder attempts(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAttempts() {
            return this.attempts(Optional.empty());
        }

        @JsonProperty(value="initialDelay")
        public abstract Builder initialDelay(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder initialDelay(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearInitialDelay() {
            return this.initialDelay(Optional.empty());
        }

        @JsonProperty(value="maxDelay")
        public abstract Builder maxDelay(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder maxDelay(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMaxDelay() {
            return this.maxDelay(Optional.empty());
        }

        @JsonProperty(value="expBase")
        public abstract Builder expBase(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder expBase(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExpBase() {
            return this.expBase(Optional.empty());
        }

        @JsonProperty(value="jitter")
        public abstract Builder jitter(Double var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder jitter(Optional<Double> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearJitter() {
            return this.jitter(Optional.empty());
        }

        @JsonProperty(value="httpStatusCodes")
        public abstract Builder httpStatusCodes(List<Integer> var1);

        @CanIgnoreReturnValue
        public Builder httpStatusCodes(Integer ... httpStatusCodes) {
            return this.httpStatusCodes(Arrays.asList(httpStatusCodes));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpStatusCodes(Optional<List<Integer>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpStatusCodes() {
            return this.httpStatusCodes(Optional.empty());
        }

        public abstract HttpRetryOptions build();
    }
}

