/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_HttpOptions;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpRetryOptions;
import java.util.Map;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class HttpOptions
extends JsonSerializable {
    @JsonProperty(value="baseUrl")
    public abstract Optional<String> baseUrl();

    @JsonProperty(value="apiVersion")
    public abstract Optional<String> apiVersion();

    @JsonProperty(value="headers")
    public abstract Optional<Map<String, String>> headers();

    @JsonProperty(value="timeout")
    public abstract Optional<Integer> timeout();

    @JsonProperty(value="extraBody")
    public abstract Optional<Map<String, Object>> extraBody();

    @JsonProperty(value="retryOptions")
    public abstract Optional<HttpRetryOptions> retryOptions();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_HttpOptions.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static HttpOptions fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, HttpOptions.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_HttpOptions.Builder();
        }

        @JsonProperty(value="baseUrl")
        public abstract Builder baseUrl(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder baseUrl(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearBaseUrl() {
            return this.baseUrl(Optional.empty());
        }

        @JsonProperty(value="apiVersion")
        public abstract Builder apiVersion(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder apiVersion(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearApiVersion() {
            return this.apiVersion(Optional.empty());
        }

        @JsonProperty(value="headers")
        public abstract Builder headers(Map<String, String> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder headers(Optional<Map<String, String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHeaders() {
            return this.headers(Optional.empty());
        }

        @JsonProperty(value="timeout")
        public abstract Builder timeout(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder timeout(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearTimeout() {
            return this.timeout(Optional.empty());
        }

        @JsonProperty(value="extraBody")
        public abstract Builder extraBody(Map<String, Object> var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder extraBody(Optional<Map<String, Object>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExtraBody() {
            return this.extraBody(Optional.empty());
        }

        @JsonProperty(value="retryOptions")
        public abstract Builder retryOptions(HttpRetryOptions var1);

        @CanIgnoreReturnValue
        public Builder retryOptions(HttpRetryOptions.Builder retryOptionsBuilder) {
            return this.retryOptions(retryOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder retryOptions(Optional<HttpRetryOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRetryOptions() {
            return this.retryOptions(Optional.empty());
        }

        public abstract HttpOptions build();
    }
}

