/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GroundingSupport;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Segment;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GroundingSupport
extends JsonSerializable {
    @JsonProperty(value="confidenceScores")
    public abstract Optional<List<Float>> confidenceScores();

    @JsonProperty(value="groundingChunkIndices")
    public abstract Optional<List<Integer>> groundingChunkIndices();

    @JsonProperty(value="segment")
    public abstract Optional<Segment> segment();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GroundingSupport.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GroundingSupport fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GroundingSupport.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GroundingSupport.Builder();
        }

        @JsonProperty(value="confidenceScores")
        public abstract Builder confidenceScores(List<Float> var1);

        @CanIgnoreReturnValue
        public Builder confidenceScores(Float ... confidenceScores) {
            return this.confidenceScores(Arrays.asList(confidenceScores));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder confidenceScores(Optional<List<Float>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearConfidenceScores() {
            return this.confidenceScores(Optional.empty());
        }

        @JsonProperty(value="groundingChunkIndices")
        public abstract Builder groundingChunkIndices(List<Integer> var1);

        @CanIgnoreReturnValue
        public Builder groundingChunkIndices(Integer ... groundingChunkIndices) {
            return this.groundingChunkIndices(Arrays.asList(groundingChunkIndices));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder groundingChunkIndices(Optional<List<Integer>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGroundingChunkIndices() {
            return this.groundingChunkIndices(Optional.empty());
        }

        @JsonProperty(value="segment")
        public abstract Builder segment(Segment var1);

        @CanIgnoreReturnValue
        public Builder segment(Segment.Builder segmentBuilder) {
            return this.segment(segmentBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder segment(Optional<Segment> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSegment() {
            return this.segment(Optional.empty());
        }

        public abstract GroundingSupport build();
    }
}

