/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerateVideosParameters;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.GenerateVideosConfig;
import com.google.genai.types.GenerateVideosSource;
import com.google.genai.types.Image;
import com.google.genai.types.Video;
import java.util.Optional;

@InternalApi
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerateVideosParameters
extends JsonSerializable {
    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="prompt")
    public abstract Optional<String> prompt();

    @JsonProperty(value="image")
    public abstract Optional<Image> image();

    @JsonProperty(value="video")
    public abstract Optional<Video> video();

    @JsonProperty(value="source")
    public abstract Optional<GenerateVideosSource> source();

    @JsonProperty(value="config")
    public abstract Optional<GenerateVideosConfig> config();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GenerateVideosParameters.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GenerateVideosParameters fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerateVideosParameters.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerateVideosParameters.Builder();
        }

        @JsonProperty(value="model")
        public abstract Builder model(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder model(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModel() {
            return this.model(Optional.empty());
        }

        @JsonProperty(value="prompt")
        public abstract Builder prompt(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder prompt(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPrompt() {
            return this.prompt(Optional.empty());
        }

        @JsonProperty(value="image")
        public abstract Builder image(Image var1);

        @CanIgnoreReturnValue
        public Builder image(Image.Builder imageBuilder) {
            return this.image(imageBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder image(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearImage() {
            return this.image(Optional.empty());
        }

        @JsonProperty(value="video")
        public abstract Builder video(Video var1);

        @CanIgnoreReturnValue
        public Builder video(Video.Builder videoBuilder) {
            return this.video(videoBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder video(Optional<Video> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearVideo() {
            return this.video(Optional.empty());
        }

        @JsonProperty(value="source")
        public abstract Builder source(GenerateVideosSource var1);

        @CanIgnoreReturnValue
        public Builder source(GenerateVideosSource.Builder sourceBuilder) {
            return this.source(sourceBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder source(Optional<GenerateVideosSource> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSource() {
            return this.source(Optional.empty());
        }

        @JsonProperty(value="config")
        public abstract Builder config(GenerateVideosConfig var1);

        @CanIgnoreReturnValue
        public Builder config(GenerateVideosConfig.Builder configBuilder) {
            return this.config(configBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder config(Optional<GenerateVideosConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearConfig() {
            return this.config(Optional.empty());
        }

        public abstract GenerateVideosParameters build();
    }
}

