/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_GenerateVideosConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.Image;
import com.google.genai.types.VideoCompressionQuality;
import com.google.genai.types.VideoGenerationMask;
import com.google.genai.types.VideoGenerationReferenceImage;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class GenerateVideosConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="numberOfVideos")
    public abstract Optional<Integer> numberOfVideos();

    @JsonProperty(value="outputGcsUri")
    public abstract Optional<String> outputGcsUri();

    @JsonProperty(value="fps")
    public abstract Optional<Integer> fps();

    @JsonProperty(value="durationSeconds")
    public abstract Optional<Integer> durationSeconds();

    @JsonProperty(value="seed")
    public abstract Optional<Integer> seed();

    @JsonProperty(value="aspectRatio")
    public abstract Optional<String> aspectRatio();

    @JsonProperty(value="resolution")
    public abstract Optional<String> resolution();

    @JsonProperty(value="personGeneration")
    public abstract Optional<String> personGeneration();

    @JsonProperty(value="pubsubTopic")
    public abstract Optional<String> pubsubTopic();

    @JsonProperty(value="negativePrompt")
    public abstract Optional<String> negativePrompt();

    @JsonProperty(value="enhancePrompt")
    public abstract Optional<Boolean> enhancePrompt();

    @JsonProperty(value="generateAudio")
    public abstract Optional<Boolean> generateAudio();

    @JsonProperty(value="lastFrame")
    public abstract Optional<Image> lastFrame();

    @JsonProperty(value="referenceImages")
    public abstract Optional<List<VideoGenerationReferenceImage>> referenceImages();

    @JsonProperty(value="mask")
    public abstract Optional<VideoGenerationMask> mask();

    @JsonProperty(value="compressionQuality")
    public abstract Optional<VideoCompressionQuality> compressionQuality();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_GenerateVideosConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static GenerateVideosConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, GenerateVideosConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_GenerateVideosConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="numberOfVideos")
        public abstract Builder numberOfVideos(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder numberOfVideos(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearNumberOfVideos() {
            return this.numberOfVideos(Optional.empty());
        }

        @JsonProperty(value="outputGcsUri")
        public abstract Builder outputGcsUri(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputGcsUri(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputGcsUri() {
            return this.outputGcsUri(Optional.empty());
        }

        @JsonProperty(value="fps")
        public abstract Builder fps(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder fps(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearFps() {
            return this.fps(Optional.empty());
        }

        @JsonProperty(value="durationSeconds")
        public abstract Builder durationSeconds(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder durationSeconds(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearDurationSeconds() {
            return this.durationSeconds(Optional.empty());
        }

        @JsonProperty(value="seed")
        public abstract Builder seed(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder seed(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSeed() {
            return this.seed(Optional.empty());
        }

        @JsonProperty(value="aspectRatio")
        public abstract Builder aspectRatio(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder aspectRatio(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAspectRatio() {
            return this.aspectRatio(Optional.empty());
        }

        @JsonProperty(value="resolution")
        public abstract Builder resolution(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder resolution(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearResolution() {
            return this.resolution(Optional.empty());
        }

        @JsonProperty(value="personGeneration")
        public abstract Builder personGeneration(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder personGeneration(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPersonGeneration() {
            return this.personGeneration(Optional.empty());
        }

        @JsonProperty(value="pubsubTopic")
        public abstract Builder pubsubTopic(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder pubsubTopic(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPubsubTopic() {
            return this.pubsubTopic(Optional.empty());
        }

        @JsonProperty(value="negativePrompt")
        public abstract Builder negativePrompt(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder negativePrompt(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearNegativePrompt() {
            return this.negativePrompt(Optional.empty());
        }

        @JsonProperty(value="enhancePrompt")
        public abstract Builder enhancePrompt(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder enhancePrompt(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEnhancePrompt() {
            return this.enhancePrompt(Optional.empty());
        }

        @JsonProperty(value="generateAudio")
        public abstract Builder generateAudio(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder generateAudio(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearGenerateAudio() {
            return this.generateAudio(Optional.empty());
        }

        @JsonProperty(value="lastFrame")
        public abstract Builder lastFrame(Image var1);

        @CanIgnoreReturnValue
        public Builder lastFrame(Image.Builder lastFrameBuilder) {
            return this.lastFrame(lastFrameBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder lastFrame(Optional<Image> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLastFrame() {
            return this.lastFrame(Optional.empty());
        }

        @JsonProperty(value="referenceImages")
        public abstract Builder referenceImages(List<VideoGenerationReferenceImage> var1);

        @CanIgnoreReturnValue
        public Builder referenceImages(VideoGenerationReferenceImage ... referenceImages) {
            return this.referenceImages(Arrays.asList(referenceImages));
        }

        @CanIgnoreReturnValue
        public Builder referenceImages(VideoGenerationReferenceImage.Builder ... referenceImagesBuilders) {
            return this.referenceImages((List)Arrays.asList(referenceImagesBuilders).stream().map(VideoGenerationReferenceImage.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceImages(Optional<List<VideoGenerationReferenceImage>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceImages() {
            return this.referenceImages(Optional.empty());
        }

        @JsonProperty(value="mask")
        public abstract Builder mask(VideoGenerationMask var1);

        @CanIgnoreReturnValue
        public Builder mask(VideoGenerationMask.Builder maskBuilder) {
            return this.mask(maskBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mask(Optional<VideoGenerationMask> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMask() {
            return this.mask(Optional.empty());
        }

        @JsonProperty(value="compressionQuality")
        public abstract Builder compressionQuality(VideoCompressionQuality var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder compressionQuality(Optional<VideoCompressionQuality> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearCompressionQuality() {
            return this.compressionQuality(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder compressionQuality(VideoCompressionQuality.Known knownType) {
            return this.compressionQuality(new VideoCompressionQuality(knownType));
        }

        @CanIgnoreReturnValue
        public Builder compressionQuality(String compressionQuality) {
            return this.compressionQuality(new VideoCompressionQuality(compressionQuality));
        }

        public abstract GenerateVideosConfig build();
    }
}

