/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_FunctionCallingConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.FunctionCallingConfigMode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class FunctionCallingConfig
extends JsonSerializable {
    @JsonProperty(value="mode")
    public abstract Optional<FunctionCallingConfigMode> mode();

    @JsonProperty(value="allowedFunctionNames")
    public abstract Optional<List<String>> allowedFunctionNames();

    @JsonProperty(value="streamFunctionCallArguments")
    public abstract Optional<Boolean> streamFunctionCallArguments();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_FunctionCallingConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static FunctionCallingConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, FunctionCallingConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_FunctionCallingConfig.Builder();
        }

        @JsonProperty(value="mode")
        public abstract Builder mode(FunctionCallingConfigMode var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder mode(Optional<FunctionCallingConfigMode> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMode() {
            return this.mode(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder mode(FunctionCallingConfigMode.Known knownType) {
            return this.mode(new FunctionCallingConfigMode(knownType));
        }

        @CanIgnoreReturnValue
        public Builder mode(String mode) {
            return this.mode(new FunctionCallingConfigMode(mode));
        }

        @JsonProperty(value="allowedFunctionNames")
        public abstract Builder allowedFunctionNames(List<String> var1);

        @CanIgnoreReturnValue
        public Builder allowedFunctionNames(String ... allowedFunctionNames) {
            return this.allowedFunctionNames(Arrays.asList(allowedFunctionNames));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder allowedFunctionNames(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAllowedFunctionNames() {
            return this.allowedFunctionNames(Optional.empty());
        }

        @JsonProperty(value="streamFunctionCallArguments")
        public abstract Builder streamFunctionCallArguments(boolean var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder streamFunctionCallArguments(Optional<Boolean> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearStreamFunctionCallArguments() {
            return this.streamFunctionCallArguments(Optional.empty());
        }

        public abstract FunctionCallingConfig build();
    }
}

