/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.ApiAuth;
import com.google.genai.types.ApiSpec;
import com.google.genai.types.AuthConfig;
import com.google.genai.types.AutoValue_ExternalApi;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.ExternalApiElasticSearchParams;
import com.google.genai.types.ExternalApiSimpleSearchParams;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ExternalApi
extends JsonSerializable {
    @JsonProperty(value="apiAuth")
    public abstract Optional<ApiAuth> apiAuth();

    @JsonProperty(value="apiSpec")
    public abstract Optional<ApiSpec> apiSpec();

    @JsonProperty(value="authConfig")
    public abstract Optional<AuthConfig> authConfig();

    @JsonProperty(value="elasticSearchParams")
    public abstract Optional<ExternalApiElasticSearchParams> elasticSearchParams();

    @JsonProperty(value="endpoint")
    public abstract Optional<String> endpoint();

    @JsonProperty(value="simpleSearchParams")
    public abstract Optional<ExternalApiSimpleSearchParams> simpleSearchParams();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_ExternalApi.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static ExternalApi fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, ExternalApi.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_ExternalApi.Builder();
        }

        @JsonProperty(value="apiAuth")
        public abstract Builder apiAuth(ApiAuth var1);

        @CanIgnoreReturnValue
        public Builder apiAuth(ApiAuth.Builder apiAuthBuilder) {
            return this.apiAuth(apiAuthBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder apiAuth(Optional<ApiAuth> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearApiAuth() {
            return this.apiAuth(Optional.empty());
        }

        @JsonProperty(value="apiSpec")
        public abstract Builder apiSpec(ApiSpec var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder apiSpec(Optional<ApiSpec> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearApiSpec() {
            return this.apiSpec(Optional.empty());
        }

        @CanIgnoreReturnValue
        public Builder apiSpec(ApiSpec.Known knownType) {
            return this.apiSpec(new ApiSpec(knownType));
        }

        @CanIgnoreReturnValue
        public Builder apiSpec(String apiSpec) {
            return this.apiSpec(new ApiSpec(apiSpec));
        }

        @JsonProperty(value="authConfig")
        public abstract Builder authConfig(AuthConfig var1);

        @CanIgnoreReturnValue
        public Builder authConfig(AuthConfig.Builder authConfigBuilder) {
            return this.authConfig(authConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder authConfig(Optional<AuthConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAuthConfig() {
            return this.authConfig(Optional.empty());
        }

        @JsonProperty(value="elasticSearchParams")
        public abstract Builder elasticSearchParams(ExternalApiElasticSearchParams var1);

        @CanIgnoreReturnValue
        public Builder elasticSearchParams(ExternalApiElasticSearchParams.Builder elasticSearchParamsBuilder) {
            return this.elasticSearchParams(elasticSearchParamsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder elasticSearchParams(Optional<ExternalApiElasticSearchParams> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearElasticSearchParams() {
            return this.elasticSearchParams(Optional.empty());
        }

        @JsonProperty(value="endpoint")
        public abstract Builder endpoint(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder endpoint(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearEndpoint() {
            return this.endpoint(Optional.empty());
        }

        @JsonProperty(value="simpleSearchParams")
        public abstract Builder simpleSearchParams(ExternalApiSimpleSearchParams var1);

        @CanIgnoreReturnValue
        public Builder simpleSearchParams(ExternalApiSimpleSearchParams.Builder simpleSearchParamsBuilder) {
            return this.simpleSearchParams(simpleSearchParamsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder simpleSearchParams(Optional<ExternalApiSimpleSearchParams> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearSimpleSearchParams() {
            return this.simpleSearchParams(Optional.empty());
        }

        public abstract ExternalApi build();
    }
}

