/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_EvaluationConfig;
import com.google.genai.types.AutoraterConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Metric;
import com.google.genai.types.OutputConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EvaluationConfig
extends JsonSerializable {
    @JsonProperty(value="metrics")
    public abstract Optional<List<Metric>> metrics();

    @JsonProperty(value="outputConfig")
    public abstract Optional<OutputConfig> outputConfig();

    @JsonProperty(value="autoraterConfig")
    public abstract Optional<AutoraterConfig> autoraterConfig();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_EvaluationConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static EvaluationConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, EvaluationConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_EvaluationConfig.Builder();
        }

        @JsonProperty(value="metrics")
        public abstract Builder metrics(List<Metric> var1);

        @CanIgnoreReturnValue
        public Builder metrics(Metric ... metrics) {
            return this.metrics(Arrays.asList(metrics));
        }

        @CanIgnoreReturnValue
        public Builder metrics(Metric.Builder ... metricsBuilders) {
            return this.metrics((List)Arrays.asList(metricsBuilders).stream().map(Metric.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder metrics(Optional<List<Metric>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearMetrics() {
            return this.metrics(Optional.empty());
        }

        @JsonProperty(value="outputConfig")
        public abstract Builder outputConfig(OutputConfig var1);

        @CanIgnoreReturnValue
        public Builder outputConfig(OutputConfig.Builder outputConfigBuilder) {
            return this.outputConfig(outputConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder outputConfig(Optional<OutputConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearOutputConfig() {
            return this.outputConfig(Optional.empty());
        }

        @JsonProperty(value="autoraterConfig")
        public abstract Builder autoraterConfig(AutoraterConfig var1);

        @CanIgnoreReturnValue
        public Builder autoraterConfig(AutoraterConfig.Builder autoraterConfigBuilder) {
            return this.autoraterConfig(autoraterConfigBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder autoraterConfig(Optional<AutoraterConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearAutoraterConfig() {
            return this.autoraterConfig(Optional.empty());
        }

        public abstract EvaluationConfig build();
    }
}

