/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.api.core.InternalApi;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_EditImageParameters;
import com.google.genai.types.EditImageConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.ReferenceImageAPI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@InternalApi
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EditImageParameters
extends JsonSerializable {
    @JsonProperty(value="model")
    public abstract Optional<String> model();

    @JsonProperty(value="prompt")
    public abstract Optional<String> prompt();

    @JsonProperty(value="referenceImages")
    public abstract Optional<List<ReferenceImageAPI>> referenceImages();

    @JsonProperty(value="config")
    public abstract Optional<EditImageConfig> config();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_EditImageParameters.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static EditImageParameters fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, EditImageParameters.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_EditImageParameters.Builder();
        }

        @JsonProperty(value="model")
        public abstract Builder model(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder model(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearModel() {
            return this.model(Optional.empty());
        }

        @JsonProperty(value="prompt")
        public abstract Builder prompt(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder prompt(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearPrompt() {
            return this.prompt(Optional.empty());
        }

        @JsonProperty(value="referenceImages")
        public abstract Builder referenceImages(List<ReferenceImageAPI> var1);

        @CanIgnoreReturnValue
        public Builder referenceImages(ReferenceImageAPI ... referenceImages) {
            return this.referenceImages(Arrays.asList(referenceImages));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder referenceImages(Optional<List<ReferenceImageAPI>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearReferenceImages() {
            return this.referenceImages(Optional.empty());
        }

        @JsonProperty(value="config")
        public abstract Builder config(EditImageConfig var1);

        @CanIgnoreReturnValue
        public Builder config(EditImageConfig.Builder configBuilder) {
            return this.config(configBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder config(Optional<EditImageConfig> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearConfig() {
            return this.config(Optional.empty());
        }

        public abstract EditImageParameters build();
    }
}

