/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_CreateAuthTokenConfig;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.LiveConnectConstraints;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class CreateAuthTokenConfig
extends JsonSerializable {
    @JsonProperty(value="httpOptions")
    public abstract Optional<HttpOptions> httpOptions();

    @JsonProperty(value="expireTime")
    public abstract Optional<Instant> expireTime();

    @JsonProperty(value="newSessionExpireTime")
    public abstract Optional<Instant> newSessionExpireTime();

    @JsonProperty(value="uses")
    public abstract Optional<Integer> uses();

    @JsonProperty(value="liveConnectConstraints")
    public abstract Optional<LiveConnectConstraints> liveConnectConstraints();

    @JsonProperty(value="lockAdditionalFields")
    public abstract Optional<List<String>> lockAdditionalFields();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_CreateAuthTokenConfig.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static CreateAuthTokenConfig fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, CreateAuthTokenConfig.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_CreateAuthTokenConfig.Builder();
        }

        @JsonProperty(value="httpOptions")
        public abstract Builder httpOptions(HttpOptions var1);

        @CanIgnoreReturnValue
        public Builder httpOptions(HttpOptions.Builder httpOptionsBuilder) {
            return this.httpOptions(httpOptionsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder httpOptions(Optional<HttpOptions> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearHttpOptions() {
            return this.httpOptions(Optional.empty());
        }

        @JsonProperty(value="expireTime")
        public abstract Builder expireTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder expireTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearExpireTime() {
            return this.expireTime(Optional.empty());
        }

        @JsonProperty(value="newSessionExpireTime")
        public abstract Builder newSessionExpireTime(Instant var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder newSessionExpireTime(Optional<Instant> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearNewSessionExpireTime() {
            return this.newSessionExpireTime(Optional.empty());
        }

        @JsonProperty(value="uses")
        public abstract Builder uses(Integer var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder uses(Optional<Integer> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearUses() {
            return this.uses(Optional.empty());
        }

        @JsonProperty(value="liveConnectConstraints")
        public abstract Builder liveConnectConstraints(LiveConnectConstraints var1);

        @CanIgnoreReturnValue
        public Builder liveConnectConstraints(LiveConnectConstraints.Builder liveConnectConstraintsBuilder) {
            return this.liveConnectConstraints(liveConnectConstraintsBuilder.build());
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder liveConnectConstraints(Optional<LiveConnectConstraints> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLiveConnectConstraints() {
            return this.liveConnectConstraints(Optional.empty());
        }

        @JsonProperty(value="lockAdditionalFields")
        public abstract Builder lockAdditionalFields(List<String> var1);

        @CanIgnoreReturnValue
        public Builder lockAdditionalFields(String ... lockAdditionalFields) {
            return this.lockAdditionalFields(Arrays.asList(lockAdditionalFields));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder lockAdditionalFields(Optional<List<String>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearLockAdditionalFields() {
            return this.lockAdditionalFields(Optional.empty());
        }

        public abstract CreateAuthTokenConfig build();
    }
}

