/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.JsonSerializable;
import com.google.genai.types.AutoValue_Content;
import com.google.genai.types.ExcludeFromGeneratedCoverageReport;
import com.google.genai.types.Part;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Content
extends JsonSerializable {
    private static final Logger logger = Logger.getLogger(Content.class.getName());

    @JsonProperty(value="parts")
    public abstract Optional<List<Part>> parts();

    @JsonProperty(value="role")
    public abstract Optional<String> role();

    @ExcludeFromGeneratedCoverageReport
    public static Builder builder() {
        return new AutoValue_Content.Builder();
    }

    public abstract Builder toBuilder();

    @ExcludeFromGeneratedCoverageReport
    public static Content fromJson(String jsonString) {
        return JsonSerializable.fromJsonString(jsonString, Content.class);
    }

    public static Content fromParts(Part ... parts) {
        return Content.builder().role("user").parts(Arrays.asList(parts)).build();
    }

    public @Nullable String text() {
        return Content.aggregateTextFromParts(this.parts().orElse(null));
    }

    static @Nullable String aggregateTextFromParts(List<Part> parts) {
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> nonTextParts = new ArrayList<String>();
        for (Part part : parts) {
            if (part.inlineData().isPresent()) {
                nonTextParts.add("inlineData");
            }
            if (part.codeExecutionResult().isPresent()) {
                nonTextParts.add("codeExecutionResult");
            }
            if (part.executableCode().isPresent()) {
                nonTextParts.add("executableCode");
            }
            if (part.fileData().isPresent()) {
                nonTextParts.add("fileData");
            }
            if (part.functionCall().isPresent()) {
                nonTextParts.add("functionCall");
            }
            if (part.functionResponse().isPresent()) {
                nonTextParts.add("functionResponse");
            }
            if (part.videoMetadata().isPresent()) {
                nonTextParts.add("videoMetadata");
            }
            if (part.thought().orElse(false).booleanValue()) continue;
            sb.append(part.text().orElse(""));
        }
        if (!nonTextParts.isEmpty()) {
            logger.warning(String.format("There are non-text parts %s in the content, returning concatenation of all text parts. Please refer to the non text parts for a full response from model.", String.join((CharSequence)", ", nonTextParts)));
        }
        return sb.toString();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        private static Builder create() {
            return new AutoValue_Content.Builder();
        }

        @JsonProperty(value="parts")
        public abstract Builder parts(List<Part> var1);

        @CanIgnoreReturnValue
        public Builder parts(Part ... parts) {
            return this.parts(Arrays.asList(parts));
        }

        @CanIgnoreReturnValue
        public Builder parts(Part.Builder ... partsBuilders) {
            return this.parts((List)Arrays.asList(partsBuilders).stream().map(Part.Builder::build).collect(ImmutableList.toImmutableList()));
        }

        @ExcludeFromGeneratedCoverageReport
        abstract Builder parts(Optional<List<Part>> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearParts() {
            return this.parts(Optional.empty());
        }

        @JsonProperty(value="role")
        public abstract Builder role(String var1);

        @ExcludeFromGeneratedCoverageReport
        abstract Builder role(Optional<String> var1);

        @ExcludeFromGeneratedCoverageReport
        @CanIgnoreReturnValue
        public Builder clearRole() {
            return this.role(Optional.empty());
        }

        public abstract Content build();
    }
}

